/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core.task;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.api.events.RandomTeleportEndEvent;
import ur.kryz.rtp.api.events.RandomTeleportStartEvent;
import ur.kryz.rtp.core.Core;
import ur.kryz.rtp.core.RandomTeleportProcessor;
import ur.kryz.rtp.core.manager.CooldownManager;
import ur.kryz.rtp.core.task.RtpContainer;
import ur.kryz.rtp.core.task.TeleportScheduler;
import ur.kryz.rtp.libs.YamlDocument;
import ur.kryz.rtp.utils.PlayerUtil;
import ur.kryz.rtp.utils.RTPUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0017\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lur/kryz/rtp/core/task/RtpTask;", "Ljava/lang/Runnable;", "module", "Lur/kryz/rtp/core/Core;", "<init>", "(Lur/kryz/rtp/core/Core;)V", "file", "Lur/kryz/rtp/libs/YamlDocument;", "scheduler", "Lur/kryz/rtp/core/task/TeleportScheduler;", "run", "", "queue", "player", "Lorg/bukkit/entity/Player;", "delay", "", "world", "Lorg/bukkit/World;", "isQueued", "", "getContainer", "Lur/kryz/rtp/core/task/RtpContainer;", "cancel", "set", "playerQueue", "", "getPlayerQueue", "()Ljava/util/Map;", "NextRTP"})
public final class RtpTask
implements Runnable {
    @NotNull
    private final Core module;
    @NotNull
    private final YamlDocument file;
    private TeleportScheduler scheduler;

    public RtpTask(@NotNull Core module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.module = module;
        this.file = this.module.getConfig();
        this.set(new TeleportScheduler(this.module));
    }

    @Override
    public void run() {
        TeleportScheduler teleportScheduler = this.scheduler;
        if (teleportScheduler == null) {
            Intrinsics.throwUninitializedPropertyAccessException("scheduler");
            teleportScheduler = null;
        }
        teleportScheduler.tick();
    }

    public final void queue(@NotNull Player player, int delay, @NotNull World world) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        RandomTeleportStartEvent event = new RandomTeleportStartEvent(player);
        PluginManager pluginManager = Bukkit.getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        PluginManager vo = pluginManager;
        if (player.hasPermission("nextrtp.bypass.timer")) {
            RandomTeleportEndEvent e = new RandomTeleportEndEvent(player);
            CompletableFuture.runAsync(() -> RtpTask.queue$lambda$3(player, world, e, this, vo));
            return;
        }
        CompletableFuture.runAsync(() -> RtpTask.queue$lambda$4(this, player, delay, world, vo, event));
    }

    public final boolean isQueued(@Nullable Player player) {
        TeleportScheduler teleportScheduler = this.scheduler;
        if (teleportScheduler == null) {
            Intrinsics.throwUninitializedPropertyAccessException("scheduler");
            teleportScheduler = null;
        }
        return teleportScheduler.isQueued(player);
    }

    @Nullable
    public final RtpContainer getContainer(@Nullable Player player) {
        TeleportScheduler teleportScheduler = this.scheduler;
        if (teleportScheduler == null) {
            Intrinsics.throwUninitializedPropertyAccessException("scheduler");
            teleportScheduler = null;
        }
        return teleportScheduler.getQueue().get(player);
    }

    public final void cancel(@Nullable Player player) {
        TeleportScheduler teleportScheduler = this.scheduler;
        if (teleportScheduler == null) {
            Intrinsics.throwUninitializedPropertyAccessException("scheduler");
            teleportScheduler = null;
        }
        teleportScheduler.cancel(player);
    }

    public final void set(@NotNull TeleportScheduler scheduler) {
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        this.scheduler = scheduler;
    }

    @NotNull
    public final Map<Player, RtpContainer> getPlayerQueue() {
        TeleportScheduler teleportScheduler = this.scheduler;
        if (teleportScheduler == null) {
            Intrinsics.throwUninitializedPropertyAccessException("scheduler");
            teleportScheduler = null;
        }
        return teleportScheduler.getQueue();
    }

    private static final void queue$lambda$3$lambda$1$lambda$0(boolean $success, RandomTeleportEndEvent $e, RtpTask this$0, Player $player, PluginManager $vo) {
        Intrinsics.checkNotNullParameter((Object)$e, "$e");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($vo, "$vo");
        if ($success) {
            $e.setFailed(false);
            CooldownManager cooldownManager = this$0.module.getCooldownManager();
            TeleportScheduler teleportScheduler = this$0.scheduler;
            if (teleportScheduler == null) {
                Intrinsics.throwUninitializedPropertyAccessException("scheduler");
                teleportScheduler = null;
            }
            Number number = this$0.file.getNumber("teleport.money");
            Intrinsics.checkNotNull(number);
            RTPUtils.processSuccess(cooldownManager, teleportScheduler, $player, number);
            $vo.callEvent((Event)$e);
        } else {
            $e.setFailed(true);
            PlayerUtil.sendParsed((CommandSender)$player, "messages.teleport.failed", new TagResolver.Single[0]);
            $vo.callEvent((Event)$e);
        }
    }

    private static final Unit queue$lambda$3$lambda$1(RandomTeleportEndEvent $e, RtpTask this$0, Player $player, PluginManager $vo, boolean success) {
        Intrinsics.checkNotNullParameter((Object)$e, "$e");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($vo, "$vo");
        NextRTPPlugin.Companion.runTask(() -> RtpTask.queue$lambda$3$lambda$1$lambda$0(success, $e, this$0, $player, $vo));
        return Unit.INSTANCE;
    }

    private static final void queue$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void queue$lambda$3(Player $player, World $world, RandomTeleportEndEvent $e, RtpTask this$0, PluginManager $vo) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter((Object)$e, "$e");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($vo, "$vo");
        RandomTeleportProcessor.random($player, $world).thenAccept(arg_0 -> RtpTask.queue$lambda$3$lambda$2(arg_0 -> RtpTask.queue$lambda$3$lambda$1($e, this$0, $player, $vo, arg_0), arg_0));
    }

    private static final void queue$lambda$4(RtpTask this$0, Player $player, int $delay, World $world, PluginManager $vo, RandomTeleportStartEvent $event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter($vo, "$vo");
        Intrinsics.checkNotNullParameter((Object)$event, "$event");
        TeleportScheduler teleportScheduler = this$0.scheduler;
        if (teleportScheduler == null) {
            Intrinsics.throwUninitializedPropertyAccessException("scheduler");
            teleportScheduler = null;
        }
        teleportScheduler.queue($player, $delay, $world);
        $vo.callEvent((Event)$event);
    }
}

