/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core.task;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.animation.ParticleProvider;
import ur.kryz.rtp.api.events.RandomTeleportEndEvent;
import ur.kryz.rtp.core.Core;
import ur.kryz.rtp.core.RandomTeleportProcessor;
import ur.kryz.rtp.core.config.RTPConfiguration;
import ur.kryz.rtp.core.manager.TitleAnimationManager;
import ur.kryz.rtp.core.task.RtpContainer;
import ur.kryz.rtp.core.task.Scheduler;
import ur.kryz.rtp.file.FileManager;
import ur.kryz.rtp.libs.YamlDocument;
import ur.kryz.rtp.parser.LegacyParser;
import ur.kryz.rtp.utils.DateFormatUtil;
import ur.kryz.rtp.utils.Debug;
import ur.kryz.rtp.utils.PlayerUtil;
import ur.kryz.rtp.utils.RTPUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010 \u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010!\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0012\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020#0\"8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lur/kryz/rtp/core/task/TeleportScheduler;", "Lur/kryz/rtp/core/task/Scheduler;", "module", "Lur/kryz/rtp/core/Core;", "<init>", "(Lur/kryz/rtp/core/Core;)V", "showDelayMessages", "", "isShowSuccessMessage", "()Z", "isShowTitles", "title", "", "getTitle", "()Ljava/lang/String;", "isShowSuccessTitles", "subtitle", "getSubtitle", "actionbar", "getActionbar", "teleportMoney", "", "tick", "", "teleportNow", "player", "Lorg/bukkit/entity/Player;", "world", "Lorg/bukkit/World;", "queue", "time", "", "isQueued", "cancel", "", "Lur/kryz/rtp/core/task/RtpContainer;", "getQueue", "()Ljava/util/Map;", "Companion", "NextRTP"})
public final class TeleportScheduler
implements Scheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Core module;
    private final boolean showDelayMessages;
    private final boolean isShowSuccessMessage;
    private final boolean isShowTitles;
    @NotNull
    private final String title;
    private final boolean isShowSuccessTitles;
    @NotNull
    private final String subtitle;
    @NotNull
    private final String actionbar;
    @NotNull
    private final Number teleportMoney;
    @NotNull
    private static final Map<Player, RtpContainer> QUEUE = new HashMap();

    public TeleportScheduler(@NotNull Core module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.module = module;
        YamlDocument file = FileManager.get("rtp.yml");
        this.showDelayMessages = file.getBoolean("titles.delay.message", (Boolean)false);
        this.isShowSuccessMessage = file.getBoolean("titles.success.message", (Boolean)true);
        this.isShowTitles = file.getBoolean("titles.enabled", (Boolean)false);
        this.teleportMoney = file.getNumber("teleport.money", (Number)100.0);
        this.isShowSuccessTitles = file.getBoolean("titles.success.ui.enabled", (Boolean)false);
        String string = file.getString("titles.success.ui.title", "");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        this.title = LegacyParser.parse(string);
        String string2 = file.getString("titles.success.ui.subtitle", "");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        this.subtitle = LegacyParser.parse(string2);
        String string3 = file.getString("titles.success.ui.actionbar", "");
        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
        this.actionbar = LegacyParser.parse(string3);
    }

    public final boolean isShowSuccessMessage() {
        return this.isShowSuccessMessage;
    }

    public final boolean isShowTitles() {
        return this.isShowTitles;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final boolean isShowSuccessTitles() {
        return this.isShowSuccessTitles;
    }

    @NotNull
    public final String getSubtitle() {
        return this.subtitle;
    }

    @NotNull
    public final String getActionbar() {
        return this.actionbar;
    }

    @Override
    public void tick() {
        Iterator<Map.Entry<Player, RtpContainer>> iterator2 = QUEUE.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Player, RtpContainer> entry = iterator2.next();
            Player player = entry.getKey();
            RtpContainer container = entry.getValue();
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            if (!container.isEquals(location)) {
                PlayerUtil.sendParsed((CommandSender)player, "messages.teleport.cancelled", new TagResolver.Single[0]);
                TitleAnimationManager.stop(player);
                this.module.getParticleAnimationManager().stopFor(player);
                iterator2.remove();
                continue;
            }
            if (container.getTeleporting()) continue;
            int tickCounter = container.getTickCounter();
            int maxTicks = container.getTime() * 20;
            if (tickCounter % 20 == 0 && tickCounter < maxTicks) {
                container.setSeconds((int)Math.max(0.0, (double)(container.getTime() - tickCounter / 20)));
                NextRTPPlugin.Companion.runTask(() -> TeleportScheduler.tick$lambda$0(player, this, container));
            }
            if (tickCounter >= maxTicks) {
                container.setTeleporting(true);
                this.cancel(player);
                this.teleportNow(player, container.getWorld());
                continue;
            }
            container.setTickCounter(tickCounter + 5);
        }
    }

    private final void teleportNow(Player player, World world) {
        RandomTeleportEndEvent event = new RandomTeleportEndEvent(player);
        PluginManager pluginManager = Bukkit.getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        PluginManager pm = pluginManager;
        Debug.INSTANCE.log("Starting teleportNow for " + player + " in " + world, new Object[0]);
        RandomTeleportProcessor.random(player, world).thenAccept(arg_0 -> TeleportScheduler.teleportNow$lambda$3(arg_0 -> TeleportScheduler.teleportNow$lambda$2(event, this, player, pm, arg_0), arg_0));
    }

    public final void queue(@NotNull Player player, int time, @NotNull World world) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(world, "world");
        Debug.INSTANCE.log("---------------------------------", new Object[0]);
        Debug.INSTANCE.log("Adding " + player + " to teleport queue.", new Object[0]);
        PlayerUtil.sendParsed((CommandSender)player, "messages.teleport.start", new TagResolver.Single[0]);
        Debug.INSTANCE.log("---------------------------------", new Object[0]);
        try {
            String string = this.module.getConfig().getString("teleport.particle.animation");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            Object object = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = ((String)object).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            String animName = string2;
            this.module.getParticleAnimationManager().startFor(player, ParticleProvider.get(animName));
            object = QUEUE;
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            RtpContainer rtpContainer = new RtpContainer(time, location, world, false, 0);
            object.put(player, rtpContainer);
            TitleAnimationManager.start(player, this.module.getConfig());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final boolean isQueued(@Nullable Player player) {
        return QUEUE.containsKey(player);
    }

    public final void cancel(@Nullable Player player) {
        RtpContainer container = (RtpContainer)TypeIntrinsics.asMutableMap(QUEUE).remove(player);
        if (container != null) {
            Player player2 = player;
            Intrinsics.checkNotNull(player2);
            TitleAnimationManager.stop(player2);
            this.module.getParticleAnimationManager().stopFor(player);
        }
    }

    @NotNull
    public final Map<Player, RtpContainer> getQueue() {
        return QUEUE;
    }

    private static final void tick$lambda$0(Player $player, TeleportScheduler this$0, RtpContainer $container) {
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($container, "$container");
        if (RTPConfiguration.INSTANCE.isEnableDelaySound()) {
            $player.playSound(RTPConfiguration.INSTANCE.getDelaySound());
        }
        if (this$0.showDelayMessages) {
            TagResolver.Single[] singleArray = new TagResolver.Single[]{Placeholder.unparsed((String)"time", (String)DateFormatUtil.formatTime($container.getSeconds()))};
            PlayerUtil.sendParsed((CommandSender)$player, "messages.teleport.delay", singleArray);
        }
    }

    private static final void teleportNow$lambda$2$lambda$1(boolean $success, RandomTeleportEndEvent $event, TeleportScheduler this$0, Player $player, PluginManager $pm) {
        Intrinsics.checkNotNullParameter((Object)$event, "$event");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($pm, "$pm");
        Debug.INSTANCE.log("--------------------------------------------------", new Object[0]);
        Debug.INSTANCE.log("Teleport random executed, result for teleport is " + $success, new Object[0]);
        if ($success) {
            $event.setFailed(false);
            RTPUtils.processSuccess(this$0.module.getCooldownManager(), this$0, $player, this$0.teleportMoney.doubleValue());
            $pm.callEvent((Event)$event);
        } else {
            $event.setFailed(true);
            PlayerUtil.sendParsed((CommandSender)$player, "messages.teleport.failed", new TagResolver.Single[0]);
            $pm.callEvent((Event)$event);
        }
    }

    private static final Unit teleportNow$lambda$2(RandomTeleportEndEvent $event, TeleportScheduler this$0, Player $player, PluginManager $pm, boolean success) {
        Intrinsics.checkNotNullParameter((Object)$event, "$event");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($pm, "$pm");
        NextRTPPlugin.Companion.runTask(() -> TeleportScheduler.teleportNow$lambda$2$lambda$1(success, $event, this$0, $player, $pm));
        return Unit.INSTANCE;
    }

    private static final void teleportNow$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lur/kryz/rtp/core/task/TeleportScheduler$Companion;", "", "<init>", "()V", "QUEUE", "", "Lorg/bukkit/entity/Player;", "Lur/kryz/rtp/core/task/RtpContainer;", "NextRTP"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

