/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core.task.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.core.adapter.BiomeAdapter;
import ur.kryz.rtp.core.task.environment.impl.Custom;
import ur.kryz.rtp.core.task.environment.impl.End;
import ur.kryz.rtp.core.task.environment.impl.Nether;
import ur.kryz.rtp.core.task.environment.impl.Overworld;
import ur.kryz.rtp.core.task.processor.RandomPoint;
import ur.kryz.rtp.file.FileManager;
import ur.kryz.rtp.utils.Debug;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002JP\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lur/kryz/rtp/core/task/processor/GeoLocation;", "", "<init>", "()V", "getRandomLocation", "Ljava/util/concurrent/CompletableFuture;", "Lur/kryz/rtp/core/task/processor/GeoLocation$ChunkLocationSnapshot;", "w", "Lorg/bukkit/World;", "a", "Lur/kryz/rtp/core/task/processor/RandomPoint$Algorithm;", "startRadius", "", "endRadius", "originX", "", "originY", "getRandomSafeLocation", "Lur/kryz/rtp/core/task/processor/GeoLocation$SafeLocation;", "maxY", "attempts", "blackListBlocks", "", "Lorg/bukkit/Material;", "blackListedBiomes", "", "reload", "", "Environment", "SafeLocation", "ChunkLocationSnapshot", "NextRTP"})
@SourceDebugExtension(value={"SMAP\nGeoLocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoLocation.kt\nur/kryz/rtp/core/task/processor/GeoLocation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1557#2:176\n1628#2,3:177\n*S KotlinDebug\n*F\n+ 1 GeoLocation.kt\nur/kryz/rtp/core/task/processor/GeoLocation\n*L\n148#1:176\n148#1:177,3\n*E\n"})
public final class GeoLocation {
    @NotNull
    public static final GeoLocation INSTANCE = new GeoLocation();
    @NotNull
    private static List<? extends Material> blackListBlocks = CollectionsKt.emptyList();
    @NotNull
    private static List<String> blackListedBiomes = CollectionsKt.emptyList();

    private GeoLocation() {
    }

    private final CompletableFuture<ChunkLocationSnapshot> getRandomLocation(World w, RandomPoint.Algorithm a, double startRadius, double endRadius, int originX, int originY) {
        try {
            Debug.INSTANCE.log("-----------------------------------------------------------", new Object[0]);
            Debug.INSTANCE.log("Before getRandomPoint", new Object[0]);
            int[] point = RandomPoint.getRandomPoint(a, startRadius, endRadius, originX, originY);
            Intrinsics.checkNotNull(point);
            Location loc = new Location(w, (double)point[0], 0.0, (double)point[1]);
            Debug.INSTANCE.log("Raw location: " + loc, new Object[0]);
            Debug.INSTANCE.log("Before World#getChunkAtAsync", new Object[0]);
            CompletableFuture completableFuture = w.getChunkAtAsync(loc, true);
            Intrinsics.checkNotNullExpressionValue(completableFuture, "getChunkAtAsync(...)");
            CompletableFuture cf = completableFuture;
            CompletionStage completionStage = cf.thenApply(arg_0 -> GeoLocation.getRandomLocation$lambda$1(arg_0 -> GeoLocation.getRandomLocation$lambda$0(loc, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
            return completionStage;
        }
        catch (Exception e) {
            Debug.INSTANCE.err("An error has occurred! Report it to Discord Support!");
            throw new UnsupportedOperationException(e);
        }
    }

    @JvmStatic
    @NotNull
    public static final CompletableFuture<SafeLocation> getRandomSafeLocation(@NotNull World w, @NotNull RandomPoint.Algorithm a, int maxY, double startRadius, double endRadius, int originX, int originY, int attempts) {
        Intrinsics.checkNotNullParameter(w, "w");
        Intrinsics.checkNotNullParameter((Object)a, "a");
        CompletableFuture<SafeLocation> future = new CompletableFuture<SafeLocation>();
        Debug.INSTANCE.log("Starting to search a safe location to teleport", new Object[0]);
        GeoLocation.getRandomSafeLocation$attempt(w, a, startRadius, endRadius, originX, originY, attempts, future, maxY, 1);
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public final void reload() {
        void $this$mapTo$iv$iv;
        List<String> list = FileManager.get("rtp.yml").getStringList("teleport.blacklisted_blocks");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Material.valueOf((String)p0));
        }
        blackListBlocks = (List)destination$iv$iv;
        blackListedBiomes = FileManager.get("rtp.yml").getStringList("teleport.blacklisted_biomes");
    }

    private static final ChunkLocationSnapshot getRandomLocation$lambda$0(Location $loc, Chunk c) {
        Intrinsics.checkNotNullParameter($loc, "$loc");
        Debug.INSTANCE.log("Result: " + c, new Object[0]);
        Debug.INSTANCE.log("Before Chunk#getChunkSnapshot", new Object[0]);
        ChunkSnapshot chunkSnapshot = c.getChunkSnapshot(true, true, true);
        Intrinsics.checkNotNullExpressionValue(chunkSnapshot, "getChunkSnapshot(...)");
        ChunkSnapshot cs = chunkSnapshot;
        Debug.INSTANCE.log("Result: " + cs + " (Object not readable)", new Object[0]);
        Debug.INSTANCE.log("Looking the highest block", new Object[0]);
        int y = cs.getHighestBlockYAt($loc.getBlockX() & 0xF, $loc.getBlockZ() & 0xF) - 1;
        $loc.setY((double)(y + 1));
        Debug.INSTANCE.log("Result: " + $loc.getY(), new Object[0]);
        Debug.INSTANCE.log("Final location: " + $loc, new Object[0]);
        Debug.INSTANCE.log("Returning ChunkLocationSnapshot", new Object[0]);
        Debug.INSTANCE.log("-----------------------------------------------------------", new Object[0]);
        return new ChunkLocationSnapshot(cs, $loc);
    }

    private static final ChunkLocationSnapshot getRandomLocation$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (ChunkLocationSnapshot)$tmp0.invoke(p0);
    }

    private static final Unit getRandomSafeLocation$attempt$lambda$2(World $w, int $tryCount, int $maxY, CompletableFuture $future, RandomPoint.Algorithm $a, double $startRadius, double $endRadius, int $originX, int $originY, int $attempts, ChunkLocationSnapshot cl) {
        Intrinsics.checkNotNullParameter($w, "$w");
        Intrinsics.checkNotNullParameter($future, "$future");
        Intrinsics.checkNotNullParameter((Object)$a, "$a");
        Debug.INSTANCE.log("Extracting info of ChunkLocationSnapshot", new Object[0]);
        Location loc = cl.location();
        ChunkSnapshot cs = cl.chunkSnapshot();
        int chunkX = loc.getBlockX() & 0xF;
        int chunkZ = loc.getBlockZ() & 0xF;
        Debug.INSTANCE.log("Verifying Location and Environment.", new Object[0]);
        if (loc.getBlockY() <= 1 && $w.getEnvironment() == World.Environment.THE_END) {
            Debug.INSTANCE.log("Location is too low in THE_END. Retrying...", new Object[0]);
            GeoLocation.getRandomSafeLocation$attempt($w, $a, $startRadius, $endRadius, $originX, $originY, $attempts, $future, $maxY, $tryCount + 1);
            return Unit.INSTANCE;
        }
        try {
            Debug.INSTANCE.log("Before ChunkSnapshot#getBiome", new Object[0]);
            Biome biome = cs.getBiome(chunkX, loc.getBlockY(), chunkZ);
            Intrinsics.checkNotNullExpressionValue(biome, "getBiome(...)");
            Biome biome2 = biome;
            Debug.INSTANCE.log("After ChunkSnapshot#getBiome", new Object[0]);
            Debug.INSTANCE.log("Verifying Biomes and Materials blacklisted", new Object[0]);
            NamespacedKey namespacedKey = (NamespacedKey)BiomeAdapter.Companion.getInstance().getKey(biome2);
            if (CollectionsKt.contains((Iterable)blackListedBiomes, namespacedKey != null ? namespacedKey.getKey() : null)) {
                Debug.INSTANCE.log("Biome is blacklisted. Retrying...", new Object[0]);
                GeoLocation.getRandomSafeLocation$attempt($w, $a, $startRadius, $endRadius, $originX, $originY, $attempts, $future, $maxY, $tryCount + 1);
                return Unit.INSTANCE;
            }
            BlockData blockData = cs.getBlockData(chunkX, loc.getBlockY(), chunkZ);
            Intrinsics.checkNotNullExpressionValue(blockData, "getBlockData(...)");
            BlockData blockData2 = blockData;
            if (blackListBlocks.contains(blockData2.getMaterial())) {
                Debug.INSTANCE.log("Block is blacklisted. Retrying...", new Object[0]);
                GeoLocation.getRandomSafeLocation$attempt($w, $a, $startRadius, $endRadius, $originX, $originY, $attempts, $future, $maxY, $tryCount + 1);
                return Unit.INSTANCE;
            }
            Debug.INSTANCE.log("Valid result", new Object[0]);
            Debug.INSTANCE.log("Getting a SafeLocation in " + $w.getEnvironment(), new Object[0]);
            World.Environment environment = $w.getEnvironment();
            Intrinsics.checkNotNullExpressionValue(environment, "getEnvironment(...)");
            Intrinsics.checkNotNull(cl);
            SafeLocation safeLocation = Environment.INSTANCE.get(environment, cl, $maxY);
            Debug.INSTANCE.log("Result: " + safeLocation + " (Object not readable)", new Object[0]);
            if (safeLocation != null) {
                $future.complete(safeLocation);
            } else {
                Debug.INSTANCE.log("SafeLocation is null. Retrying...", new Object[0]);
                GeoLocation.getRandomSafeLocation$attempt($w, $a, $startRadius, $endRadius, $originX, $originY, $attempts, $future, $maxY, $tryCount + 1);
            }
        }
        catch (Exception e) {
            Debug.INSTANCE.err("Error during biome or block check: " + e.getMessage());
            GeoLocation.getRandomSafeLocation$attempt($w, $a, $startRadius, $endRadius, $originX, $originY, $attempts, $future, $maxY, $tryCount + 1);
        }
        return Unit.INSTANCE;
    }

    private static final void getRandomSafeLocation$attempt$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Void getRandomSafeLocation$attempt$lambda$4(int $tryCount, World $w, RandomPoint.Algorithm $a, double $startRadius, double $endRadius, int $originX, int $originY, int $attempts, CompletableFuture $future, int $maxY, Throwable ex) {
        Intrinsics.checkNotNullParameter($w, "$w");
        Intrinsics.checkNotNullParameter((Object)$a, "$a");
        Intrinsics.checkNotNullParameter($future, "$future");
        Debug.INSTANCE.err("Exception during getRandomLocation: " + ex.getMessage());
        GeoLocation.getRandomSafeLocation$attempt($w, $a, $startRadius, $endRadius, $originX, $originY, $attempts, $future, $maxY, $tryCount + 1);
        return null;
    }

    private static final void getRandomSafeLocation$attempt(World $w, RandomPoint.Algorithm $a, double $startRadius, double $endRadius, int $originX, int $originY, int $attempts, CompletableFuture<SafeLocation> future, int $maxY, int tryCount) {
        Debug.INSTANCE.log("-----------------------------------------------------------", new Object[0]);
        Debug.INSTANCE.log("Attempt: " + tryCount, new Object[0]);
        ((CompletableFuture)INSTANCE.getRandomLocation($w, $a, $startRadius, $endRadius, $originX, $originY).thenAccept(arg_0 -> GeoLocation.getRandomSafeLocation$attempt$lambda$3(arg_0 -> GeoLocation.getRandomSafeLocation$attempt$lambda$2($w, tryCount, $maxY, future, $a, $startRadius, $endRadius, $originX, $originY, $attempts, arg_0), arg_0))).exceptionally(arg_0 -> GeoLocation.getRandomSafeLocation$attempt$lambda$4(tryCount, $w, $a, $startRadius, $endRadius, $originX, $originY, $attempts, future, $maxY, arg_0));
        Debug.INSTANCE.log("-----------------------------------------------------------", new Object[0]);
        if (tryCount >= $attempts) {
            Debug.INSTANCE.log("Max attempts reached. Returning null.", new Object[0]);
            Debug.INSTANCE.log("-----------------------------------------------------------", new Object[0]);
            future.complete(null);
            return;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0015"}, d2={"Lur/kryz/rtp/core/task/processor/GeoLocation$ChunkLocationSnapshot;", "Ljava/lang/Record;", "chunkSnapshot", "Lorg/bukkit/ChunkSnapshot;", "location", "Lorg/bukkit/Location;", "<init>", "(Lorg/bukkit/ChunkSnapshot;Lorg/bukkit/Location;)V", "()Lorg/bukkit/ChunkSnapshot;", "()Lorg/bukkit/Location;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "NextRTP"})
    public static final class ChunkLocationSnapshot
    extends Record {
        @NotNull
        private final ChunkSnapshot chunkSnapshot;
        @NotNull
        private final Location location;

        public ChunkLocationSnapshot(@NotNull ChunkSnapshot chunkSnapshot, @NotNull Location location) {
            Intrinsics.checkNotNullParameter(chunkSnapshot, "chunkSnapshot");
            Intrinsics.checkNotNullParameter(location, "location");
            this.chunkSnapshot = chunkSnapshot;
            this.location = location;
        }

        @NotNull
        public final ChunkSnapshot chunkSnapshot() {
            return this.chunkSnapshot;
        }

        @NotNull
        public final Location location() {
            return this.location;
        }

        @NotNull
        public final ChunkSnapshot component1() {
            return this.chunkSnapshot;
        }

        @NotNull
        public final Location component2() {
            return this.location;
        }

        @NotNull
        public final ChunkLocationSnapshot copy(@NotNull ChunkSnapshot chunkSnapshot, @NotNull Location location) {
            Intrinsics.checkNotNullParameter(chunkSnapshot, "chunkSnapshot");
            Intrinsics.checkNotNullParameter(location, "location");
            return new ChunkLocationSnapshot(chunkSnapshot, location);
        }

        public static /* synthetic */ ChunkLocationSnapshot copy$default(ChunkLocationSnapshot chunkLocationSnapshot, ChunkSnapshot chunkSnapshot, Location location, int n, Object object) {
            if ((n & 1) != 0) {
                chunkSnapshot = chunkLocationSnapshot.chunkSnapshot;
            }
            if ((n & 2) != 0) {
                location = chunkLocationSnapshot.location;
            }
            return chunkLocationSnapshot.copy(chunkSnapshot, location);
        }

        @Override
        @NotNull
        public String toString() {
            return "ChunkLocationSnapshot(chunkSnapshot=" + this.chunkSnapshot + ", location=" + this.location + ")";
        }

        @Override
        public int hashCode() {
            int result = this.chunkSnapshot.hashCode();
            result = result * 31 + this.location.hashCode();
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChunkLocationSnapshot)) {
                return false;
            }
            ChunkLocationSnapshot chunkLocationSnapshot = (ChunkLocationSnapshot)other;
            if (!Intrinsics.areEqual(this.chunkSnapshot, chunkLocationSnapshot.chunkSnapshot)) {
                return false;
            }
            return Intrinsics.areEqual(this.location, chunkLocationSnapshot.location);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lur/kryz/rtp/core/task/processor/GeoLocation$Environment;", "", "<init>", "()V", "ENVIRONMENT", "", "Lorg/bukkit/World$Environment;", "Lur/kryz/rtp/core/task/environment/Environment;", "get", "Lur/kryz/rtp/core/task/processor/GeoLocation$SafeLocation;", "environment", "chunkLocationSnapshot", "Lur/kryz/rtp/core/task/processor/GeoLocation$ChunkLocationSnapshot;", "maxY", "", "NextRTP"})
    private static final class Environment {
        @NotNull
        public static final Environment INSTANCE = new Environment();
        @NotNull
        private static final Map<World.Environment, ur.kryz.rtp.core.task.environment.Environment> ENVIRONMENT;

        private Environment() {
        }

        @Nullable
        public final SafeLocation get(@NotNull World.Environment environment, @NotNull ChunkLocationSnapshot chunkLocationSnapshot, int maxY) {
            Intrinsics.checkNotNullParameter(environment, "environment");
            Intrinsics.checkNotNullParameter(chunkLocationSnapshot, "chunkLocationSnapshot");
            ur.kryz.rtp.core.task.environment.Environment environment2 = ENVIRONMENT.get(environment);
            Intrinsics.checkNotNull(environment2);
            return environment2.getSafeLocation(chunkLocationSnapshot, maxY);
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to(World.Environment.NORMAL, new Overworld()), TuplesKt.to(World.Environment.NETHER, new Nether()), TuplesKt.to(World.Environment.THE_END, new End()), TuplesKt.to(World.Environment.CUSTOM, new Custom())};
            ENVIRONMENT = MapsKt.mapOf(pairArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000bR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\f\u00a8\u0006\u0018"}, d2={"Lur/kryz/rtp/core/task/processor/GeoLocation$SafeLocation;", "Ljava/lang/Record;", "tries", "", "location", "Lorg/bukkit/Location;", "chunkSnapshot", "Lorg/bukkit/ChunkSnapshot;", "<init>", "(ILorg/bukkit/Location;Lorg/bukkit/ChunkSnapshot;)V", "(Lorg/bukkit/Location;Lorg/bukkit/ChunkSnapshot;)V", "()I", "()Lorg/bukkit/ChunkSnapshot;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "NextRTP"})
    public static final class SafeLocation
    extends Record {
        private final int tries;
        @JvmField
        @NotNull
        public final Location location;
        @NotNull
        private final ChunkSnapshot chunkSnapshot;

        public SafeLocation(int tries, @NotNull Location location, @NotNull ChunkSnapshot chunkSnapshot) {
            Intrinsics.checkNotNullParameter(location, "location");
            Intrinsics.checkNotNullParameter(chunkSnapshot, "chunkSnapshot");
            this.tries = tries;
            this.location = location;
            this.chunkSnapshot = chunkSnapshot;
        }

        public final int tries() {
            return this.tries;
        }

        @NotNull
        public final ChunkSnapshot chunkSnapshot() {
            return this.chunkSnapshot;
        }

        public SafeLocation(@NotNull Location location, @NotNull ChunkSnapshot chunkSnapshot) {
            Intrinsics.checkNotNullParameter(location, "location");
            Intrinsics.checkNotNullParameter(chunkSnapshot, "chunkSnapshot");
            this(0, location, chunkSnapshot);
        }

        public final int component1() {
            return this.tries;
        }

        @NotNull
        public final Location component2() {
            return this.location;
        }

        @NotNull
        public final ChunkSnapshot component3() {
            return this.chunkSnapshot;
        }

        @NotNull
        public final SafeLocation copy(int tries, @NotNull Location location, @NotNull ChunkSnapshot chunkSnapshot) {
            Intrinsics.checkNotNullParameter(location, "location");
            Intrinsics.checkNotNullParameter(chunkSnapshot, "chunkSnapshot");
            return new SafeLocation(tries, location, chunkSnapshot);
        }

        public static /* synthetic */ SafeLocation copy$default(SafeLocation safeLocation, int n, Location location, ChunkSnapshot chunkSnapshot, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = safeLocation.tries;
            }
            if ((n2 & 2) != 0) {
                location = safeLocation.location;
            }
            if ((n2 & 4) != 0) {
                chunkSnapshot = safeLocation.chunkSnapshot;
            }
            return safeLocation.copy(n, location, chunkSnapshot);
        }

        @Override
        @NotNull
        public String toString() {
            return "SafeLocation(tries=" + this.tries + ", location=" + this.location + ", chunkSnapshot=" + this.chunkSnapshot + ")";
        }

        @Override
        public int hashCode() {
            int result = Integer.hashCode(this.tries);
            result = result * 31 + this.location.hashCode();
            result = result * 31 + this.chunkSnapshot.hashCode();
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SafeLocation)) {
                return false;
            }
            SafeLocation safeLocation = (SafeLocation)other;
            if (this.tries != safeLocation.tries) {
                return false;
            }
            if (!Intrinsics.areEqual(this.location, safeLocation.location)) {
                return false;
            }
            return Intrinsics.areEqual(this.chunkSnapshot, safeLocation.chunkSnapshot);
        }
    }
}

