/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core.task.processor;

import java.util.Random;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J(\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J(\u0010\u0011\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lur/kryz/rtp/core/task/processor/RandomPoint;", "", "<init>", "()V", "RANDOM", "Ljava/util/Random;", "getRandomPoint", "", "algorithm", "Lur/kryz/rtp/core/task/processor/RandomPoint$Algorithm;", "startRadius", "", "endRadius", "originX", "", "originY", "generateRandomPointOnCircle", "generateRandomPointOnSquare", "radius", "baseX", "baseZ", "Algorithm", "NextRTP"})
public final class RandomPoint {
    @NotNull
    public static final RandomPoint INSTANCE = new RandomPoint();
    @NotNull
    private static final Random RANDOM = new Random();

    private RandomPoint() {
    }

    @JvmStatic
    @Nullable
    public static final int[] getRandomPoint(@Nullable Algorithm algorithm, double startRadius, double endRadius, int originX, int originY) {
        int[] randomPoint = null;
        if (algorithm == null) {
            return null;
        }
        if (algorithm == Algorithm.CIRCLE) {
            randomPoint = INSTANCE.generateRandomPointOnCircle(startRadius, endRadius, originX, originY);
        }
        if (algorithm == Algorithm.SQUARE) {
            randomPoint = INSTANCE.generateRandomPointOnSquare(endRadius, originX, originY);
        }
        return randomPoint;
    }

    private final int[] generateRandomPointOnCircle(double startRadius, double endRadius, int originX, int originY) {
        double angle = RANDOM.nextDouble() * (double)2 * Math.PI;
        double radius = startRadius + RANDOM.nextDouble() * (endRadius - startRadius);
        int x = originX + (int)(radius * Math.cos(angle));
        int y = originY + (int)(radius * Math.sin(angle));
        int[] nArray = new int[]{x, y};
        return nArray;
    }

    private final int[] generateRandomPointOnSquare(double startRadius, double endRadius, int originX, int originY) {
        double sideLength = endRadius - startRadius;
        int xDirection = RANDOM.nextBoolean() ? 1 : -1;
        int yDirection = RANDOM.nextBoolean() ? 1 : -1;
        int x = originX + xDirection * ((int)(RANDOM.nextDouble() * sideLength) + (int)startRadius);
        int y = originY + yDirection * ((int)(RANDOM.nextDouble() * sideLength) + (int)startRadius);
        int[] nArray = new int[]{x, y};
        return nArray;
    }

    private final int[] generateRandomPointOnSquare(double radius, int baseX, int baseZ) {
        int x = RANDOM.nextInt((int)((double)baseX - radius), (int)((double)baseX + radius));
        int z = RANDOM.nextInt((int)((double)baseZ - radius), (int)((double)baseZ + radius));
        int[] nArray = new int[]{x, z};
        return nArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lur/kryz/rtp/core/task/processor/RandomPoint$Algorithm;", "", "<init>", "(Ljava/lang/String;I)V", "CIRCLE", "SQUARE", "NextRTP"})
    public static final class Algorithm
    extends Enum<Algorithm> {
        public static final /* enum */ Algorithm CIRCLE = new Algorithm();
        public static final /* enum */ Algorithm SQUARE = new Algorithm();
        private static final /* synthetic */ Algorithm[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Algorithm[] values() {
            return (Algorithm[])$VALUES.clone();
        }

        public static Algorithm valueOf(String value) {
            return Enum.valueOf(Algorithm.class, value);
        }

        @NotNull
        public static EnumEntries<Algorithm> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = algorithmArray = new Algorithm[]{Algorithm.CIRCLE, Algorithm.SQUARE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

