/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.core.task.processor;

import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.core.task.CyclicTaskScheduler;
import ur.kryz.rtp.core.task.processor.GeoLocation;
import ur.kryz.rtp.core.task.processor.RandomPoint;
import ur.kryz.rtp.utils.Debug;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JR\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\f\u00a8\u0006\u0014"}, d2={"Lur/kryz/rtp/core/task/processor/TeleportRandom;", "", "<init>", "()V", "teleport", "Ljava/util/concurrent/CompletableFuture;", "", "w", "Lorg/bukkit/World;", "a", "Lur/kryz/rtp/core/task/processor/RandomPoint$Algorithm;", "maxY", "", "radius", "", "originX", "originY", "e", "Lorg/bukkit/entity/Entity;", "attempts", "NextRTP"})
public final class TeleportRandom {
    @NotNull
    public static final TeleportRandom INSTANCE = new TeleportRandom();

    private TeleportRandom() {
    }

    @NotNull
    public final CompletableFuture<Boolean> teleport(@Nullable World w, @Nullable RandomPoint.Algorithm a, int maxY, double radius, int originX, int originY, @Nullable Entity e, int attempts) {
        Debug.INSTANCE.log("Executing TeleportRandom#teleport", new Object[0]);
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        if (w == null || a == null || e == null) {
            completableFuture.complete(false);
            Debug.INSTANCE.log("A essential parameter is null, returning failed teleport.", new Object[0]);
            return completableFuture;
        }
        CyclicTaskScheduler.Companion.register(() -> TeleportRandom.teleport$lambda$5(w, a, maxY, radius, originX, originY, attempts, completableFuture, e), -1L);
        return completableFuture;
    }

    private static final Unit teleport$lambda$5$lambda$2$lambda$0(CompletableFuture $completableFuture, Boolean success, Throwable throwable) {
        Intrinsics.checkNotNullParameter($completableFuture, "$completableFuture");
        Debug.INSTANCE.log("Result of Player#teleportAsync in TeleportRandom#teleport: " + success, new Object[0]);
        Debug.INSTANCE.log("Throwable: " + throwable, new Object[0]);
        if (throwable != null) {
            throwable.printStackTrace();
            v0 = $completableFuture.complete(false);
        } else {
            v0 = $completableFuture.complete(success);
        }
        return Unit.INSTANCE;
    }

    private static final void teleport$lambda$5$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Unit teleport$lambda$5$lambda$2(CompletableFuture $completableFuture, Entity $e, GeoLocation.SafeLocation safeLoc) {
        Intrinsics.checkNotNullParameter($completableFuture, "$completableFuture");
        if (safeLoc == null) {
            Debug.INSTANCE.log("No safe location found, returning failed teleport.", new Object[0]);
            v0 = $completableFuture.complete(false);
        } else {
            Location location = safeLoc.location.clone().add(0.0, 1.0, 0.0);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            Location destination = location;
            Debug.INSTANCE.log("Attempting teleport to " + destination, new Object[0]);
            v0 = $e.teleportAsync(destination).whenComplete((arg_0, arg_1) -> TeleportRandom.teleport$lambda$5$lambda$2$lambda$1((arg_0, arg_1) -> TeleportRandom.teleport$lambda$5$lambda$2$lambda$0($completableFuture, arg_0, arg_1), arg_0, arg_1));
        }
        Debug.INSTANCE.log("-----------------------------------------------------------", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final void teleport$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Void teleport$lambda$5$lambda$4(CompletableFuture $completableFuture, Throwable ex) {
        Intrinsics.checkNotNullParameter($completableFuture, "$completableFuture");
        Debug.INSTANCE.err("Exception while searching for safe location: " + ex.getMessage());
        ex.printStackTrace();
        $completableFuture.complete(false);
        return null;
    }

    private static final void teleport$lambda$5(World $w, RandomPoint.Algorithm $a, int $maxY, double $radius, int $originX, int $originY, int $attempts, CompletableFuture $completableFuture, Entity $e) {
        Intrinsics.checkNotNullParameter($completableFuture, "$completableFuture");
        Debug.INSTANCE.log("-----------------------------------------------------------", new Object[0]);
        Debug.INSTANCE.log("Starting async task for random teleport.", new Object[0]);
        ((CompletableFuture)GeoLocation.getRandomSafeLocation($w, $a, $maxY, $radius, $radius, $originX, $originY, $attempts).thenAccept(arg_0 -> TeleportRandom.teleport$lambda$5$lambda$3(arg_0 -> TeleportRandom.teleport$lambda$5$lambda$2($completableFuture, $e, arg_0), arg_0))).exceptionally(arg_0 -> TeleportRandom.teleport$lambda$5$lambda$4($completableFuture, arg_0));
    }
}

