/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.file;

import java.io.File;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ur.kryz.rtp.NextRTPPlugin;
import ur.kryz.rtp.file.YamlFile;
import ur.kryz.rtp.libs.YamlDocument;
import ur.kryz.rtp.libs.dvs.versioning.BasicVersioning;
import ur.kryz.rtp.libs.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import ur.kryz.rtp.libs.settings.Settings;
import ur.kryz.rtp.libs.settings.dumper.DumperSettings;
import ur.kryz.rtp.libs.settings.general.GeneralSettings;
import ur.kryz.rtp.libs.settings.loader.LoaderSettings;
import ur.kryz.rtp.libs.settings.updater.UpdaterSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lur/kryz/rtp/file/FileManager;", "", "<init>", "()V", "FILE_MAP", "", "", "Lur/kryz/rtp/libs/YamlDocument;", "settings", "Lur/kryz/rtp/libs/settings/updater/UpdaterSettings;", "loader", "Lur/kryz/rtp/libs/settings/loader/LoaderSettings;", "generalSettings", "Lur/kryz/rtp/libs/settings/general/GeneralSettings;", "dumperSettings", "Lur/kryz/rtp/libs/settings/dumper/DumperSettings;", "load", "name", "plugin", "Lur/kryz/rtp/NextRTPPlugin;", "get", "updaterVersionOne", "", "yamlDocument", "NextRTP"})
public final class FileManager {
    @NotNull
    public static final FileManager INSTANCE = new FileManager();
    @NotNull
    private static final Map<String, YamlDocument> FILE_MAP = new HashMap();
    @NotNull
    private static final UpdaterSettings settings;
    @NotNull
    private static final LoaderSettings loader;
    @NotNull
    private static final GeneralSettings generalSettings;
    @NotNull
    private static final DumperSettings dumperSettings;

    private FileManager() {
    }

    @JvmStatic
    @NotNull
    public static final YamlDocument load(@NotNull String name, @NotNull NextRTPPlugin plugin) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        File file = new File(plugin.getDataFolder(), name);
        InputStream inputStream = plugin.getResource(name);
        if (inputStream == null) {
            throw new IllegalStateException("Resource not found: " + name);
        }
        InputStream stream = inputStream;
        Settings[] settingsArray = new Settings[]{settings, loader, generalSettings, dumperSettings};
        YamlDocument yamlDocument = YamlDocument.create(file, stream, settingsArray);
        YamlFile.INSTANCE.load(file, stream);
        yamlDocument.update();
        FILE_MAP.put(file.getName(), yamlDocument);
        Intrinsics.checkNotNull(yamlDocument);
        return yamlDocument;
    }

    @JvmStatic
    @NotNull
    public static final YamlDocument get(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Object realName = StringsKt.endsWith$default(name, ".yml", false, 2, null) ? name : name + ".yml";
        YamlDocument yamlDocument = FILE_MAP.get(realName);
        if (yamlDocument == null) {
            throw new NoSuchFileException("File not found: " + name);
        }
        return yamlDocument;
    }

    private final void updaterVersionOne(YamlDocument yamlDocument) {
        String particle = yamlDocument.getString("teleport.particle_animation");
        yamlDocument.set("teleport.particle.enabled", (Object)true);
        yamlDocument.set("teleport.particle.animation", (Object)particle);
        yamlDocument.remove("teleport.particle_animation");
    }

    private static final void settings$lambda$0(YamlDocument it) {
        Intrinsics.checkNotNull(it);
        INSTANCE.updaterVersionOne(it);
    }

    static {
        UpdaterSettings updaterSettings = UpdaterSettings.builder().setVersioning(new BasicVersioning("config-version")).addCustomLogic("2", FileManager::settings$lambda$0).setAutoSave(true).build();
        Intrinsics.checkNotNullExpressionValue(updaterSettings, "build(...)");
        settings = updaterSettings;
        LoaderSettings loaderSettings = LoaderSettings.builder().build();
        Intrinsics.checkNotNullExpressionValue(loaderSettings, "build(...)");
        loader = loaderSettings;
        GeneralSettings generalSettings = GeneralSettings.builder().setKeyFormat(GeneralSettings.KeyFormat.OBJECT).build();
        Intrinsics.checkNotNullExpressionValue(generalSettings, "build(...)");
        FileManager.generalSettings = generalSettings;
        DumperSettings dumperSettings = DumperSettings.builder().setFlowStyle(FlowStyle.BLOCK).build();
        Intrinsics.checkNotNullExpressionValue(dumperSettings, "build(...)");
        FileManager.dumperSettings = dumperSettings;
    }
}

