/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.libs.settings.updater;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ur.kryz.rtp.libs.block.Block;
import ur.kryz.rtp.libs.block.implementation.Section;
import ur.kryz.rtp.libs.route.Route;

public interface ValueMapper {
    @Nullable
    default public Object map(@NotNull Section section, @NotNull Route key) {
        return this.map(section.getBlock(key));
    }

    @Nullable
    default public Object map(@NotNull Block<?> block) {
        return this.map(block.getStoredValue());
    }

    @Nullable
    default public Object map(@Nullable Object value) {
        return value;
    }

    public static ValueMapper section(final BiFunction<Section, Route, Object> mapper) {
        return new ValueMapper(){

            @Override
            public Object map(@NotNull Section section, @NotNull Route key) {
                return mapper.apply(section, key);
            }
        };
    }

    public static ValueMapper block(final Function<Block<?>, Object> mapper) {
        return new ValueMapper(){

            @Override
            public Object map(@NotNull Block<?> block) {
                return mapper.apply(block);
            }
        };
    }

    public static ValueMapper value(final Function<Object, Object> mapper) {
        return new ValueMapper(){

            @Override
            public Object map(@Nullable Object value) {
                return mapper.apply(value);
            }
        };
    }
}

