/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.modules.location.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ur.kryz.rtp.core.brigadier.Arguments;
import ur.kryz.rtp.core.command.paper.DisplayableUsage;
import ur.kryz.rtp.core.command.paper.SubCommand;
import ur.kryz.rtp.modules.location.LocationModule;
import ur.kryz.rtp.modules.location.manager.LocationCooldownManager;
import ur.kryz.rtp.modules.location.obj.ImmutableLocationObject;
import ur.kryz.rtp.utils.DateFormatUtil;
import ur.kryz.rtp.utils.PlayerUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lur/kryz/rtp/modules/location/command/LocationCommand;", "Lur/kryz/rtp/core/command/paper/SubCommand;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "Lur/kryz/rtp/core/command/paper/DisplayableUsage;", "<init>", "()V", "build", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "builder", "execute", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "usage", "Utils", "NextRTP"})
public final class LocationCommand
implements SubCommand<CommandSourceStack>,
DisplayableUsage {
    @Override
    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build(@NotNull LiteralArgumentBuilder<CommandSourceStack> builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        ArgumentBuilder argumentBuilder = builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"location").requires(LocationCommand::build$lambda$0)).then((ArgumentBuilder)Commands.argument((String)"location", (ArgumentType)((ArgumentType)Arguments.INSTANCE.locationArgument())))).executes(arg_0 -> LocationCommand.build$lambda$1(this, arg_0)));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    @Override
    public int execute(@NotNull CommandContext<CommandSourceStack> context) {
        Intrinsics.checkNotNullParameter(context, "context");
        Object object = context.getArgument("location", Optional.class);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.util.Optional<ur.kryz.rtp.modules.location.obj.ImmutableLocationObject>");
        Optional opt = (Optional)object;
        ImmutableLocationObject location = (ImmutableLocationObject)OptionalsKt.getOrNull(opt);
        if (location == null) {
            CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            PlayerUtil.sendParsed(commandSender, "messages.command.invalid_location", new TagResolver.Single[0]);
            return 1;
        }
        return 1;
    }

    @Override
    public int usage(@NotNull CommandContext<CommandSourceStack> context) {
        Intrinsics.checkNotNullParameter(context, "context");
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        PlayerUtil.sendParsed(commandSender, "messages.usage.rtp_location", new TagResolver.Single[0]);
        return 1;
    }

    private static final boolean build$lambda$0(CommandSourceStack it) {
        return it.getSender().hasPermission("nextrtp.command.location");
    }

    private static final int build$lambda$1(LocationCommand this$0, CommandContext it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNull(it);
        return this$0.usage((CommandContext<CommandSourceStack>)it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lur/kryz/rtp/modules/location/command/LocationCommand$Utils;", "", "<init>", "()V", "rtp", "", "player", "Lorg/bukkit/entity/Player;", "module", "Lur/kryz/rtp/modules/location/LocationModule;", "immutableLocationObject", "Lur/kryz/rtp/modules/location/obj/ImmutableLocationObject;", "NextRTP"})
    private static final class Utils {
        @NotNull
        public static final Utils INSTANCE = new Utils();

        private Utils() {
        }

        public final void rtp(@NotNull Player player, @NotNull LocationModule module, @NotNull ImmutableLocationObject immutableLocationObject) {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(module, "module");
            Intrinsics.checkNotNullParameter(immutableLocationObject, "immutableLocationObject");
            if (module.getTask().isQueued(player)) {
                PlayerUtil.sendParsed((CommandSender)player, "messages.teleport.progress", new TagResolver.Single[0]);
                return;
            }
            double money = immutableLocationObject.getMoney();
            String permString = "nextrtp.location." + immutableLocationObject.getWorld().getName();
            if (!player.hasPermission(permString) && !player.hasPermission("nextrtp.location.*")) {
                TagResolver.Single[] singleArray = new TagResolver.Single[]{Placeholder.unparsed((String)"world_name", (String)immutableLocationObject.getWorld().getName())};
                PlayerUtil.sendParsed((CommandSender)player, "messages.world.not_allowed", singleArray);
                return;
            }
            if (!PlayerUtil.hasMoney(player, money) && !player.hasPermission("nextrtp.bypass.money")) {
                TagResolver.Single[] singleArray = new TagResolver.Single[]{Placeholder.unparsed((String)"money", (String)String.valueOf(money))};
                PlayerUtil.sendParsed((CommandSender)player, "messages.currency.no_money", singleArray);
                return;
            }
            LocationCooldownManager cooldownManager = LocationCooldownManager.INSTANCE;
            if (cooldownManager.isOnCooldown(player, immutableLocationObject)) {
                long left = cooldownManager.getTimeLeft(player, immutableLocationObject) / (long)1000;
                TagResolver.Single[] singleArray = new TagResolver.Single[]{Placeholder.unparsed((String)"time", (String)DateFormatUtil.formatTime((int)left))};
                PlayerUtil.sendParsed((CommandSender)player, "messages.teleport.cooldown", singleArray);
                return;
            }
            module.getTask().queue(player, immutableLocationObject);
        }
    }
}

