/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.modules.location.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ur.kryz.rtp.modules.location.obj.ImmutableLocationObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fR&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lur/kryz/rtp/modules/location/manager/LocationCooldownManager;", "", "<init>", "()V", "cooldowns", "", "Ljava/util/UUID;", "Lur/kryz/rtp/modules/location/obj/ImmutableLocationObject;", "", "isOnCooldown", "", "player", "Lorg/bukkit/entity/Player;", "location", "getTimeLeft", "applyCooldown", "", "clear", "clearAll", "NextRTP"})
@SourceDebugExtension(value={"SMAP\nLocationCooldownManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationCooldownManager.kt\nur/kryz/rtp/modules/location/manager/LocationCooldownManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class LocationCooldownManager {
    @NotNull
    public static final LocationCooldownManager INSTANCE = new LocationCooldownManager();
    @NotNull
    private static final Map<UUID, Map<ImmutableLocationObject, Long>> cooldowns = new HashMap();

    private LocationCooldownManager() {
    }

    public final boolean isOnCooldown(@NotNull Player player, @NotNull ImmutableLocationObject location) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        long now = System.currentTimeMillis();
        Map<ImmutableLocationObject, Long> map2 = cooldowns.get(player.getUniqueId());
        if (map2 == null) {
            return false;
        }
        Map<ImmutableLocationObject, Long> playerCooldowns = map2;
        Long l = playerCooldowns.get(location);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            bl = it > now;
        } else {
            bl = false;
        }
        return bl;
    }

    public final long getTimeLeft(@NotNull Player player, @NotNull ImmutableLocationObject location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        long now = System.currentTimeMillis();
        Map<ImmutableLocationObject, Long> map2 = cooldowns.get(player.getUniqueId());
        if (map2 == null || (map2 = map2.get(location)) == null) {
            return 0L;
        }
        long timeLeft = (Long)((Object)map2);
        return (long)Math.max(0.0, (double)(timeLeft - now));
    }

    public final void applyCooldown(@NotNull Player player, @NotNull ImmutableLocationObject location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        long expiration = System.currentTimeMillis() + (long)location.getCooldown() * 1000L;
        Map map2 = cooldowns.computeIfAbsent(player.getUniqueId(), arg_0 -> LocationCooldownManager.applyCooldown$lambda$2(LocationCooldownManager::applyCooldown$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue(map2, "computeIfAbsent(...)");
        Map map3 = map2;
        Long l = expiration;
        map3.put(location, l);
    }

    public final void clear(@NotNull Player player, @NotNull ImmutableLocationObject location) {
        block0: {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(location, "location");
            Map<ImmutableLocationObject, Long> map2 = cooldowns.get(player.getUniqueId());
            if (map2 == null) break block0;
            map2.remove(location);
        }
    }

    public final void clearAll(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        cooldowns.remove(player.getUniqueId());
    }

    private static final Map applyCooldown$lambda$1(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new HashMap();
    }

    private static final Map applyCooldown$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Map)$tmp0.invoke(p0);
    }
}

