/*
 * Decompiled with CFR 0.152.
 */
package ur.kryz.rtp.modules.sign.listener;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ur.kryz.rtp.api.events.SignTeleportStartEvent;
import ur.kryz.rtp.core.Core;
import ur.kryz.rtp.core.command.RtpCommand;
import ur.kryz.rtp.libs.YamlDocument;
import ur.kryz.rtp.modules.sign.SignModule;
import ur.kryz.rtp.utils.PlayerUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J(\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lur/kryz/rtp/modules/sign/listener/SignListener;", "Lorg/bukkit/event/Listener;", "module", "Lur/kryz/rtp/modules/sign/SignModule;", "<init>", "(Lur/kryz/rtp/modules/sign/SignModule;)V", "namespacedKey", "Lorg/bukkit/NamespacedKey;", "plain", "Lnet/kyori/adventure/text/serializer/plain/PlainTextComponentSerializer;", "Lorg/jetbrains/annotations/NotNull;", "onSign", "", "event", "Lorg/bukkit/event/block/SignChangeEvent;", "onBlockInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "isRtpSign", "", "lines", "", "Lnet/kyori/adventure/text/Component;", "expectedLine", "", "ignoreCase", "NextRTP"})
public final class SignListener
implements Listener {
    @NotNull
    private final SignModule module;
    @NotNull
    private final NamespacedKey namespacedKey;
    @NotNull
    private final PlainTextComponentSerializer plain;

    public SignListener(@NotNull SignModule module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.module = module;
        this.namespacedKey = new NamespacedKey((Plugin)this.module.getPlugin(), "rtp_sign");
        PlainTextComponentSerializer plainTextComponentSerializer = PlainTextComponentSerializer.plainText();
        Intrinsics.checkNotNullExpressionValue(plainTextComponentSerializer, "plainText(...)");
        this.plain = plainTextComponentSerializer;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onSign(@NotNull SignChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        List list = event.lines();
        Intrinsics.checkNotNullExpressionValue(list, "lines(...)");
        List lines = list;
        YamlDocument config = this.module.getSignFile();
        if (!player2.hasPermission("urrtp.sign")) {
            return;
        }
        String string = config.getString("sign.line");
        Boolean bl = config.getBoolean("sign.ignore-case", (Boolean)true);
        Intrinsics.checkNotNullExpressionValue(bl, "getBoolean(...)");
        if (!this.isRtpSign(lines, string, bl)) {
            return;
        }
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        BlockState blockState = block2.getState();
        Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.Sign");
        Sign sign = (Sign)blockState;
        Location location = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location l = location;
        PersistentDataContainer persistentDataContainer = sign.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer container = persistentDataContainer;
        Boolean is = (Boolean)container.get(this.namespacedKey, PersistentDataType.BOOLEAN);
        if (container.has(this.namespacedKey)) {
            return;
        }
        if (Intrinsics.areEqual(is, false) || is != null) {
            return;
        }
        container.set(this.namespacedKey, PersistentDataType.BOOLEAN, (Object)true);
        if (!sign.update()) {
            throw new UnsupportedOperationException("The update of the sign not success.");
        }
        TagResolver.Single[] singleArray = new TagResolver.Single[]{Placeholder.unparsed((String)"x", (String)String.valueOf(l.getX())), Placeholder.unparsed((String)"y", (String)String.valueOf(l.getY())), Placeholder.unparsed((String)"z", (String)String.valueOf(l.getZ()))};
        PlayerUtil.sendParsed((CommandSender)player2, "messages.sign.success", singleArray);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onBlockInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block block2 = block;
        BlockState blockState = block2.getState();
        Sign sign = blockState instanceof Sign ? (Sign)blockState : null;
        if (sign == null) {
            return;
        }
        Sign state = sign;
        PersistentDataContainer persistentDataContainer = state.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer container = persistentDataContainer;
        Boolean bl = (Boolean)container.get(this.namespacedKey, PersistentDataType.BOOLEAN);
        if (bl == null) {
            return;
        }
        boolean is = bl;
        if (!is) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        SignTeleportStartEvent mE = new SignTeleportStartEvent(player2, state);
        Bukkit.getPluginManager().callEvent((Event)mE);
        if (mE.isCancelled()) {
            return;
        }
        Core core = this.module.getPlugin().getCore();
        World world = player2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        RtpCommand.Util.rtp(core, player2, world);
    }

    private final boolean isRtpSign(List<? extends Component> lines, String expectedLine, boolean ignoreCase) {
        for (Component component : lines) {
            String text;
            Intrinsics.checkNotNullExpressionValue(this.plain.serialize(component), "serialize(...)");
            if (!(ignoreCase ? StringsKt.equals(text, expectedLine, true) : Intrinsics.areEqual(text, expectedLine))) continue;
            return true;
        }
        return false;
    }
}

