/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.bone;

import dev.apexstudios.apexcore.lib.util.WoodTypeBuilder;
import dev.apexstudios.fantasyfurniture.block.FurnitureDoorBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneBedDoubleBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneBedSingleBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneBenchBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneBookshelfBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneChairBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneChandelierBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneChestBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneCounterBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneCushionBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneDeskLeftBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneDeskRightBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneDrawerBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneDresserBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneFloorLightBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneLockBoxBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneOvenBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BonePaintingSmallBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BonePaintingWideBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneShelfBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneSofaBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneStoolBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneTableBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneWallLightBlock;
import dev.apexstudios.fantasyfurniture.bone.block.BoneWardrobeBlock;
import dev.apexstudios.fantasyfurniture.util.FurnitureUtil;
import dev.apexstudios.registree.api.Registree;
import dev.apexstudios.registree.api.holder.DeferredBlock;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.AddPackFindersEvent;

public final class BoneFurnitureSet {
    public static final String ID = "fantasyfurniture_bone";
    public final String id;
    public final Registree registree;
    public final WoodType woodType;
    public final DeferredBlock<Block> bricks;
    public final DeferredBlock<Block> wool;
    public final DeferredBlock<CarpetBlock> carpet;
    public final DeferredBlock<BoneDresserBlock> dresser;
    public final DeferredBlock<BoneStoolBlock> stool;
    public final DeferredBlock<BoneCushionBlock> cushion;
    public final DeferredBlock<BoneLockBoxBlock> lockbox;
    public final DeferredBlock<BoneDrawerBlock> drawer;
    public final DeferredBlock<BoneChairBlock> chair;
    public final DeferredBlock<BoneBookshelfBlock> bookshelf;
    public final DeferredBlock<BoneBedSingleBlock> bedSingle;
    public final DeferredBlock<BoneBedDoubleBlock> bedDouble;
    public final DeferredBlock<FurnitureDoorBlock> doorSingle;
    public final DeferredBlock<FurnitureDoorBlock> doorDouble;
    public final DeferredBlock<BoneDeskLeftBlock> deskLeft;
    public final DeferredBlock<BoneDeskRightBlock> deskRight;
    public final DeferredBlock<BonePaintingWideBlock> paintingWide;
    public final DeferredBlock<BonePaintingSmallBlock> paintingSmall;
    public final DeferredBlock<BoneOvenBlock> oven;
    public final DeferredBlock<BoneChestBlock> chest;
    public final DeferredBlock<BoneFloorLightBlock> floorLight;
    public final DeferredBlock<BoneChandelierBlock> chandelier;
    public final DeferredBlock<BoneShelfBlock> shelf;
    public final DeferredBlock<BoneSofaBlock> sofa;
    public final DeferredBlock<BoneCounterBlock> counter;
    public final DeferredBlock<BoneWallLightBlock> wallLight;
    public final DeferredBlock<BoneBenchBlock> bench;
    public final DeferredBlock<BoneWardrobeBlock> wardrobe;
    public final DeferredBlock<BoneTableBlock> table;
    public final DeferredBlock<StairBlock> stairs;
    public final DeferredBlock<SlabBlock> slab;
    public final DeferredBlock<FenceBlock> fence;
    public final DeferredBlock<FenceGateBlock> fenceGate;
    public final DeferredBlock<TrapDoorBlock> trapdoor;
    public final DeferredBlock<PressurePlateBlock> pressurePlate;
    public final FurnitureUtil.SignPair<CeilingHangingSignBlock, WallHangingSignBlock> hangingSign;
    public final FurnitureUtil.SignPair<StandingSignBlock, WallSignBlock> sign;
    public final ResourceKey<CreativeModeTab> creativeModeTab;

    protected BoneFurnitureSet(String modId, String id) {
        this.id = id;
        this.registree = Registree.create((String)modId);
        this.woodType = WoodTypeBuilder.builder().copy(WoodType.OAK).blockSetType(blockSet -> blockSet.copy(BlockSetType.STONE)).build(this.registree.registryIdentifier(id));
        this.bricks = FurnitureUtil.bricks((Registree)this.registree, Block::new);
        this.wool = FurnitureUtil.wool((Registree)this.registree, Block::new);
        this.carpet = FurnitureUtil.carpet((Registree)this.registree, CarpetBlock::new);
        this.dresser = FurnitureUtil.dresser((Registree)this.registree, BoneDresserBlock::new);
        this.stool = FurnitureUtil.stool((Registree)this.registree, BoneStoolBlock::new);
        this.cushion = FurnitureUtil.cushion((Registree)this.registree, BoneCushionBlock::new);
        this.lockbox = FurnitureUtil.lockbox((Registree)this.registree, BoneLockBoxBlock::new);
        this.drawer = FurnitureUtil.drawer((Registree)this.registree, BoneDrawerBlock::new);
        this.chair = FurnitureUtil.chair((Registree)this.registree, BoneChairBlock::new);
        this.bookshelf = FurnitureUtil.bookshelf((Registree)this.registree, BoneBookshelfBlock::new);
        this.bedSingle = FurnitureUtil.bedSingle((Registree)this.registree, BoneBedSingleBlock::new);
        this.bedDouble = FurnitureUtil.bedDouble((Registree)this.registree, BoneBedDoubleBlock::new);
        this.doorSingle = FurnitureUtil.doorSingle((Registree)this.registree, (BlockSetType)this.woodType.setType(), FurnitureDoorBlock::new);
        this.doorDouble = FurnitureUtil.doorDouble((Registree)this.registree, (BlockSetType)this.woodType.setType(), FurnitureDoorBlock::new);
        this.deskLeft = FurnitureUtil.desk((Registree)this.registree, (boolean)true, BoneDeskLeftBlock::new);
        this.deskRight = FurnitureUtil.desk((Registree)this.registree, (boolean)false, BoneDeskRightBlock::new);
        this.paintingWide = FurnitureUtil.paintingWide((Registree)this.registree, BonePaintingWideBlock::new);
        this.paintingSmall = FurnitureUtil.paintingSmall((Registree)this.registree, BonePaintingSmallBlock::new);
        this.oven = FurnitureUtil.oven((Registree)this.registree, BoneOvenBlock::new);
        this.chest = FurnitureUtil.chest((Registree)this.registree, BoneChestBlock::new);
        this.floorLight = FurnitureUtil.floorLight((Registree)this.registree, BoneFloorLightBlock::new);
        this.chandelier = FurnitureUtil.chandelier((Registree)this.registree, BoneChandelierBlock::new);
        this.shelf = FurnitureUtil.shelf((Registree)this.registree, BoneShelfBlock::new);
        this.sofa = FurnitureUtil.sofa((Registree)this.registree, BoneSofaBlock::new);
        this.counter = FurnitureUtil.counter((Registree)this.registree, BoneCounterBlock::new);
        this.wallLight = FurnitureUtil.wallLight((Registree)this.registree, BoneWallLightBlock::new);
        this.bench = FurnitureUtil.bench((Registree)this.registree, BoneBenchBlock::new);
        this.wardrobe = FurnitureUtil.wardrobe((Registree)this.registree, BoneWardrobeBlock::new);
        this.table = FurnitureUtil.table((Registree)this.registree, BoneTableBlock::new);
        this.stairs = FurnitureUtil.stairs((Registree)this.registree, this.bricks);
        this.slab = FurnitureUtil.slab((Registree)this.registree);
        this.fence = FurnitureUtil.fence((Registree)this.registree);
        this.fenceGate = FurnitureUtil.fenceGate((Registree)this.registree, (WoodType)this.woodType);
        this.trapdoor = FurnitureUtil.trapdoor((Registree)this.registree, (BlockSetType)this.woodType.setType());
        this.pressurePlate = FurnitureUtil.pressurePlate((Registree)this.registree, (BlockSetType)this.woodType.setType());
        this.hangingSign = FurnitureUtil.hangingSign((Registree)this.registree, (WoodType)this.woodType);
        this.sign = FurnitureUtil.sign((Registree)this.registree, (WoodType)this.woodType);
        this.creativeModeTab = FurnitureUtil.creativeModeTab((Registree)this.registree, this.bedSingle);
    }

    public void register(IEventBus modBus) {
        FurnitureUtil.registerEvents((IEventBus)modBus, (Registree)this.registree, (WoodType)this.woodType);
        modBus.addListener(AddPackFindersEvent.class, event -> {
            this.addPackFinder((AddPackFindersEvent)event, PackType.CLIENT_RESOURCES);
            this.addPackFinder((AddPackFindersEvent)event, PackType.SERVER_DATA);
        });
    }

    private void addPackFinder(AddPackFindersEvent event, PackType packType) {
        event.addPackFinders(this.registree.registryName(BoneFurnitureSet.packPath(packType, this)), packType, (Component)Component.literal((String)"Fantasy's Furniture - Bone"), PackSource.DEFAULT, true, Pack.Position.BOTTOM);
    }

    public static String packPath(PackType packType, BoneFurnitureSet furnitureSet) {
        return "built-in/" + packType.getDirectory() + "/" + furnitureSet.id;
    }
}

