/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.bone.block;

import dev.apexstudios.fantasyfurniture.block.WallLightBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BoneWallLightBlock
extends WallLightBlock {
    public static final VoxelShape SHAPE = BoneWallLightBlock.box((double)6.0, (double)4.0, (double)9.0, (double)10.0, (double)15.0, (double)16.0);

    public BoneWallLightBlock(BlockBehaviour.Properties properties) {
        super(ParticleTypes.SOUL_FIRE_FLAME, properties, SHAPE);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.7;
        double z = (double)pos.getZ() + 0.5;
        Direction facing = ((Direction)blockState.getValue((Property)FACING)).getOpposite();
        double offset = 0.1;
        double offsetZ = offset * (double)facing.getStepZ();
        double offsetX = offset * (double)facing.getStepX();
        this.addParticles(level, x + offsetX, y + 0.35, z + offsetZ);
    }

    private void addParticles(Level level, double x, double y, double z) {
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)this.flameParticle, x, y, z, 0.0, 0.0, 0.0);
    }
}

