/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.ppekkungz.util.LockData;
import net.ppekkungz.util.PasswordUtil;

public final class ChestLockManager {
    private static final Map<class_4208, LockData> LOCKED = new ConcurrentHashMap<class_4208, LockData>();
    private static Path savePath;

    private ChestLockManager() {
    }

    public static boolean isLocked(class_1937 level, class_2338 pos) {
        if (level.field_9236) {
            return false;
        }
        return LOCKED.containsKey(ChestLockManager.global(level, pos));
    }

    public static Optional<LockData> getLock(class_1937 level, class_2338 pos) {
        if (level.field_9236) {
            return Optional.empty();
        }
        return Optional.ofNullable(LOCKED.get(ChestLockManager.global(level, pos)));
    }

    public static boolean lock(class_3218 level, class_2338 pos, UUID owner, String rawPassword) {
        class_4208 g = ChestLockManager.global((class_1937)level, pos);
        if (LOCKED.containsKey(g)) {
            return false;
        }
        String hash = PasswordUtil.hash(rawPassword);
        LockData data = new LockData(g, owner, hash);
        LOCKED.put(g, data);
        ChestLockManager.save();
        return true;
    }

    public static boolean unlock(class_3218 level, class_2338 pos, UUID playerId) {
        class_4208 g = ChestLockManager.global((class_1937)level, pos);
        LockData data = LOCKED.get(g);
        if (data == null) {
            return false;
        }
        if (!data.owner().equals(playerId)) {
            return false;
        }
        LOCKED.remove(g);
        ChestLockManager.save();
        return true;
    }

    public static boolean canAccess(class_3218 level, class_2338 pos, UUID playerId, String passwordOrEmpty) {
        class_4208 g = ChestLockManager.global((class_1937)level, pos);
        LockData data = LOCKED.get(g);
        if (data == null) {
            return true;
        }
        if (data.owner().equals(playerId)) {
            return true;
        }
        if (data.whitelist().contains(playerId)) {
            return true;
        }
        if (!passwordOrEmpty.isEmpty()) {
            return PasswordUtil.matches(passwordOrEmpty, data.passwordHash());
        }
        return false;
    }

    public static boolean addToWhitelist(class_3218 level, class_2338 pos, UUID owner, UUID target) {
        class_4208 g = ChestLockManager.global((class_1937)level, pos);
        LockData data = LOCKED.get(g);
        if (data == null || !data.owner().equals(owner)) {
            return false;
        }
        data.whitelist().add(target);
        ChestLockManager.save();
        return true;
    }

    public static boolean removeFromWhitelist(class_3218 level, class_2338 pos, UUID owner, UUID target) {
        class_4208 g = ChestLockManager.global((class_1937)level, pos);
        LockData data = LOCKED.get(g);
        if (data == null || !data.owner().equals(owner)) {
            return false;
        }
        data.whitelist().remove(target);
        ChestLockManager.save();
        return true;
    }

    private static class_4208 global(class_1937 level, class_2338 pos) {
        class_5321 dim = level.method_27983();
        return class_4208.method_19443((class_5321)dim, (class_2338)pos);
    }

    public static void load(Path path) {
        savePath = path;
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonArray arr = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            for (JsonElement el : arr) {
                LockData data = LockData.fromJson(el.getAsJsonObject());
                LOCKED.put(data.pos(), data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean unlockWithKey(class_3218 level, class_2338 pos, UUID keyOwnerUuid, String rawPassword) {
        class_4208 g = class_4208.method_19443((class_5321)level.method_27983(), (class_2338)pos);
        LockData data = LOCKED.get(g);
        if (data == null) {
            return false;
        }
        if (!data.owner().equals(keyOwnerUuid)) {
            return false;
        }
        if (!PasswordUtil.matches(rawPassword, data.passwordHash())) {
            return false;
        }
        LOCKED.remove(g);
        ChestLockManager.save();
        return true;
    }

    public static void save() {
        if (savePath == null) {
            return;
        }
        JsonArray arr = new JsonArray();
        for (LockData data : LOCKED.values()) {
            arr.add((JsonElement)data.toJson());
        }
        try (BufferedWriter writer = Files.newBufferedWriter(savePath, new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)arr, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

