/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.util;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;
import net.ppekkungz.ChestLockManager;
import net.ppekkungz.util.LockData;

public final class ChestAccessCommand {
    private ChestAccessCommand() {
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, env) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chestaccess").requires(src -> src.method_9259(0))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            class_3222 executor = ((class_2168)ctx.getSource()).method_9207();
            String targetName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            return ChestAccessCommand.handleAdd(((class_2168)ctx.getSource()).method_9211(), executor, targetName);
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            class_3222 executor = ((class_2168)ctx.getSource()).method_9207();
            String targetName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            return ChestAccessCommand.handleRemove(((class_2168)ctx.getSource()).method_9211(), executor, targetName);
        })))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_3222 executor = ((class_2168)ctx.getSource()).method_9207();
            return ChestAccessCommand.handleList(((class_2168)ctx.getSource()).method_9211(), executor);
        }))));
    }

    private static int handleAdd(MinecraftServer server, class_3222 player, String targetName) {
        class_3222 target = server.method_3760().method_14566(targetName);
        if (target == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u274c Player not found."), false);
            return 0;
        }
        Optional<BlockTarget> block = ChestAccessCommand.getTargetedChest(player);
        if (block.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u26a0\ufe0f Look at a chest to add access."), false);
            return 0;
        }
        boolean ok = ChestLockManager.addToWhitelist(block.get().level, block.get().pos, player.method_5667(), target.method_5667());
        if (ok) {
            player.method_7353((class_2561)class_2561.method_43470((String)("\u2705 Added " + targetName + " to chest whitelist.")), false);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u26a0\ufe0f You must own this chest."), false);
        }
        return 1;
    }

    private static int handleRemove(MinecraftServer server, class_3222 player, String targetName) {
        class_3222 target = server.method_3760().method_14566(targetName);
        if (target == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u274c Player not found."), false);
            return 0;
        }
        Optional<BlockTarget> block = ChestAccessCommand.getTargetedChest(player);
        if (block.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u26a0\ufe0f Look at a chest to remove access."), false);
            return 0;
        }
        boolean ok = ChestLockManager.removeFromWhitelist(block.get().level, block.get().pos, player.method_5667(), target.method_5667());
        if (ok) {
            player.method_7353((class_2561)class_2561.method_43470((String)("\ud83d\uddd1 Removed " + targetName + " from whitelist.")), false);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u26a0\ufe0f You must own this chest."), false);
        }
        return 1;
    }

    private static int handleList(MinecraftServer server, class_3222 player) {
        Optional<BlockTarget> block = ChestAccessCommand.getTargetedChest(player);
        if (block.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u26a0\ufe0f Look at a chest to view whitelist."), false);
            return 0;
        }
        Optional<LockData> dataOpt = ChestLockManager.getLock((class_1937)block.get().level, block.get().pos);
        if (dataOpt.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u274c This chest is not locked."), false);
            return 0;
        }
        LockData data = dataOpt.get();
        if (!data.owner().equals(player.method_5667())) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u26a0\ufe0f You must own this chest."), false);
            return 0;
        }
        if (data.whitelist().isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\ud83d\udced No players in whitelist."), false);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"\ud83d\udc65 Whitelisted players:"), false);
            data.whitelist().forEach(uuid -> {
                class_3222 p = server.method_3760().method_14602(uuid);
                String name = p != null ? p.method_5477().getString() : uuid.toString();
                player.method_7353((class_2561)class_2561.method_43470((String)(" - " + name)), false);
            });
        }
        return 1;
    }

    private static Optional<BlockTarget> getTargetedChest(class_3222 player) {
        class_2680 state;
        class_243 eyePos = player.method_33571();
        class_243 lookDir = player.method_5720();
        class_243 target = eyePos.method_1019(lookDir.method_1021(5.0));
        class_3965 hit = player.method_37908().method_17742(new class_3959(eyePos, target, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        if (hit.method_17783() == class_239.class_240.field_1332 && (state = player.method_37908().method_8320(hit.method_17777())).method_26204() instanceof class_2281) {
            return Optional.of(new BlockTarget((class_3218)player.method_37908(), hit.method_17777()));
        }
        return Optional.empty();
    }

    private record BlockTarget(class_3218 level, class_2338 pos) {
    }
}

