/*
 * Decompiled with CFR 0.152.
 */
package me.mangregory.asr.items;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import me.mangregory.asr.config.ClientConfigCache;
import me.mangregory.asr.config.ModConfig;
import me.mangregory.asr.mixin.LivingEntityAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public class GiantSwordItem
extends class_1792 {
    private long maxBlockDuration;
    private static final Map<String, Integer> cooldownMap = new HashMap<String, Integer>();

    public GiantSwordItem(class_1792.class_1793 properties) {
        super(properties);
        this.updateMaxBlockDuration();
    }

    @NotNull
    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        LivingEntityAccessor accessor;
        if (player instanceof LivingEntityAccessor && (accessor = (LivingEntityAccessor)player).getAttackStrengthTicker() < 10) {
            return class_1269.field_5811;
        }
        this.updateMaxBlockDuration();
        super.method_7836(level, player, hand);
        if (ModConfig.ENABLE_GIANT_SWORD_EQUIP_SOUND) {
            player.method_73183().method_8396(null, class_2338.method_49638((class_2374)player.method_30950(0.0f)), class_3417.field_14649, class_3419.field_15248, 0.8f, 0.8f + player.method_73183().field_9229.method_43057() * 0.4f);
        }
        return class_1269.field_21466;
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 72000;
    }

    public boolean method_7840(class_1799 stack, class_1937 level, class_1309 entity, int timeUsed) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!level.method_8608()) {
                String key = this.getCooldownKey(player, stack);
                player.method_7357().method_62835(stack, this.getCooldown(key) / 2);
                this.resetCooldown(key);
            }
        }
        return false;
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int remainingUseDuration) {
        if (!level.method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            String key = this.getCooldownKey(player, stack);
            this.incrementCooldown(key, 1);
            if ((long)this.getCooldown(key) >= this.maxBlockDuration) {
                entity.method_6021();
                player.method_7357().method_62835(stack, this.getCooldown(key) / 2);
                this.resetCooldown(key);
            }
        }
    }

    private String getCooldownKey(class_1657 player, class_1799 stack) {
        int slot = player.method_31548().method_7395(stack);
        return String.valueOf(player.method_5667()) + ":" + slot;
    }

    private int getCooldown(String key) {
        return cooldownMap.getOrDefault(key, 0);
    }

    private void resetCooldown(String key) {
        cooldownMap.remove(key);
    }

    public int getCooldown(class_1657 player, class_1799 stack) {
        String key = this.getCooldownKey(player, stack);
        return this.getCooldown(key);
    }

    public void resetCooldown(class_1657 player, class_1799 stack) {
        String key = this.getCooldownKey(player, stack);
        this.resetCooldown(key);
    }

    private void incrementCooldown(String key, int value) {
        cooldownMap.put(key, this.getCooldown(key) + value);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 tooltipDisplay, Consumer<class_2561> tooltipAdder, class_1836 flag) {
        long displayDuration;
        super.method_67187(stack, context, tooltipDisplay, tooltipAdder, flag);
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        if (mc.method_1496()) {
            this.updateMaxBlockDuration();
            displayDuration = this.maxBlockDuration;
        } else {
            displayDuration = ClientConfigCache.giantSwordBlockDuration;
        }
        tooltipAdder.accept((class_2561)class_2561.method_43470((String)("Maximum Block Duration: " + displayDuration / 20L + "s")).method_27692(class_124.field_1075));
    }

    private void updateMaxBlockDuration() {
        this.maxBlockDuration = ModConfig.GIANT_SWORD_BLOCK_DURATION;
    }
}

