/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.api.actions.types;

import lombok.Generated;
import org.prism_mc.prism.api.actions.Action;
import org.prism_mc.prism.api.actions.ActionData;
import org.prism_mc.prism.api.actions.metadata.Metadata;
import org.prism_mc.prism.api.actions.types.ActionResultType;

public abstract class ActionType {
    protected final String key;
    protected final ActionResultType resultType;
    protected final boolean reversible;
    protected final Metadata metadata;
    protected final boolean usesDescriptor;

    public ActionType(String key, ActionResultType resultType, boolean reversible) {
        this(key, resultType, reversible, true, null);
    }

    public ActionType(String key, ActionResultType resultType, boolean reversible, boolean usesDescriptor) {
        this(key, resultType, reversible, usesDescriptor, null);
    }

    public ActionType(String key, ActionResultType resultType, boolean reversible, boolean usesDescriptor, Metadata metadata) {
        this.key = key;
        this.metadata = metadata;
        this.resultType = resultType;
        this.reversible = reversible;
        this.usesDescriptor = usesDescriptor;
    }

    public String familyKey() {
        String[] segments = this.key.split("-");
        return segments[segments.length - 1];
    }

    public String pastTenseTranslationKey() {
        return "prism.past-tense." + this.key;
    }

    public abstract Action createAction(ActionData var1) throws Exception;

    public String toString() {
        return String.format("ActionType{key=%s,resultType=%s,reversible=%s,usesDescriptor=%s}", new Object[]{this.key, this.resultType, this.reversible, this.usesDescriptor});
    }

    @Generated
    public String key() {
        return this.key;
    }

    @Generated
    public ActionResultType resultType() {
        return this.resultType;
    }

    @Generated
    public boolean reversible() {
        return this.reversible;
    }

    @Generated
    public Metadata metadata() {
        return this.metadata;
    }

    @Generated
    public boolean usesDescriptor() {
        return this.usesDescriptor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionType)) {
            return false;
        }
        ActionType other = (ActionType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.reversible() != other.reversible()) {
            return false;
        }
        if (this.usesDescriptor() != other.usesDescriptor()) {
            return false;
        }
        String this$key = this.key();
        String other$key = other.key();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        ActionResultType this$resultType = this.resultType();
        ActionResultType other$resultType = other.resultType();
        if (this$resultType == null ? other$resultType != null : !((Object)((Object)this$resultType)).equals((Object)other$resultType)) {
            return false;
        }
        Metadata this$metadata = this.metadata();
        Metadata other$metadata = other.metadata();
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActionType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.reversible() ? 79 : 97);
        result = result * 59 + (this.usesDescriptor() ? 79 : 97);
        String $key = this.key();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        ActionResultType $resultType = this.resultType();
        result = result * 59 + ($resultType == null ? 43 : ((Object)((Object)$resultType)).hashCode());
        Metadata $metadata = this.metadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }
}

