/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.api.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.prism_mc.prism.api.actions.types.ActionType;
import org.prism_mc.prism.api.util.Coordinate;

public class ActivityQuery {
    private Collection<String> actionTypeKeys;
    private Collection<ActionType> actionTypes;
    private Collection<Integer> activityIds;
    private Long after;
    private Long before;
    private Collection<String> affectedBlocks;
    private Collection<String> causeBlocks;
    private String namedCause;
    private Collection<String> defaultsUsed;
    private Collection<String> affectedEntityTypes;
    private Collection<String> causeEntityTypes;
    private boolean grouped;
    private int limit;
    private Coordinate coordinate;
    private boolean lookup;
    private Collection<String> affectedMaterials;
    private Coordinate maxCoordinate;
    private Coordinate minCoordinate;
    private int offset;
    private Collection<String> affectedPlayerNames;
    private Collection<String> causePlayerNames;
    private String descriptor;
    private Coordinate referenceCoordinate;
    private Boolean reversed;
    private Sort sort;
    private UUID worldUuid;

    public boolean modification() {
        return !this.lookup && !this.grouped;
    }

    public Set<String> allActionTypeKeys() {
        HashSet<String> all = new HashSet<String>(this.actionTypeKeys);
        for (ActionType actionType : this.actionTypes()) {
            all.add(actionType.key());
        }
        return all;
    }

    @Generated
    private static boolean $default$grouped() {
        return true;
    }

    @Generated
    private static boolean $default$lookup() {
        return true;
    }

    @Generated
    private static int $default$offset() {
        return 0;
    }

    @Generated
    private static Sort $default$sort() {
        return Sort.DESCENDING;
    }

    @Generated
    protected ActivityQuery(ActivityQueryBuilder<?, ?> b) {
        this.actionTypeKeys = switch (b.actionTypeKeys == null ? 0 : b.actionTypeKeys.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.actionTypeKeys.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.actionTypeKeys));
        };
        this.actionTypes = switch (b.actionTypes == null ? 0 : b.actionTypes.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.actionTypes.get(0));
            default -> Collections.unmodifiableList(new ArrayList<ActionType>(b.actionTypes));
        };
        this.activityIds = b.activityIds;
        this.after = b.after;
        this.before = b.before;
        this.affectedBlocks = switch (b.affectedBlocks == null ? 0 : b.affectedBlocks.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.affectedBlocks.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.affectedBlocks));
        };
        this.causeBlocks = switch (b.causeBlocks == null ? 0 : b.causeBlocks.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.causeBlocks.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.causeBlocks));
        };
        this.namedCause = b.namedCause;
        this.defaultsUsed = switch (b.defaultsUsed == null ? 0 : b.defaultsUsed.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.defaultsUsed.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.defaultsUsed));
        };
        this.affectedEntityTypes = switch (b.affectedEntityTypes == null ? 0 : b.affectedEntityTypes.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.affectedEntityTypes.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.affectedEntityTypes));
        };
        this.causeEntityTypes = switch (b.causeEntityTypes == null ? 0 : b.causeEntityTypes.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.causeEntityTypes.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.causeEntityTypes));
        };
        this.grouped = b.grouped$set ? b.grouped$value : ActivityQuery.$default$grouped();
        this.limit = b.limit;
        this.coordinate = b.coordinate;
        this.lookup = b.lookup$set ? b.lookup$value : ActivityQuery.$default$lookup();
        this.affectedMaterials = switch (b.affectedMaterials == null ? 0 : b.affectedMaterials.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.affectedMaterials.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.affectedMaterials));
        };
        this.maxCoordinate = b.maxCoordinate;
        this.minCoordinate = b.minCoordinate;
        this.offset = b.offset$set ? b.offset$value : ActivityQuery.$default$offset();
        this.affectedPlayerNames = switch (b.affectedPlayerNames == null ? 0 : b.affectedPlayerNames.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.affectedPlayerNames.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.affectedPlayerNames));
        };
        this.causePlayerNames = switch (b.causePlayerNames == null ? 0 : b.causePlayerNames.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.causePlayerNames.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.causePlayerNames));
        };
        this.descriptor = b.descriptor;
        this.referenceCoordinate = b.referenceCoordinate;
        this.reversed = b.reversed;
        this.sort = b.sort$set ? b.sort$value : ActivityQuery.$default$sort();
        this.worldUuid = b.worldUuid;
    }

    @Generated
    public static ActivityQueryBuilder<?, ?> builder() {
        return new ActivityQueryBuilderImpl();
    }

    @Generated
    public ActivityQueryBuilder<?, ?> toBuilder() {
        return new ActivityQueryBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Collection<String> actionTypeKeys() {
        return this.actionTypeKeys;
    }

    @Generated
    public Collection<ActionType> actionTypes() {
        return this.actionTypes;
    }

    @Generated
    public Collection<Integer> activityIds() {
        return this.activityIds;
    }

    @Generated
    public Long after() {
        return this.after;
    }

    @Generated
    public Long before() {
        return this.before;
    }

    @Generated
    public Collection<String> affectedBlocks() {
        return this.affectedBlocks;
    }

    @Generated
    public Collection<String> causeBlocks() {
        return this.causeBlocks;
    }

    @Generated
    public String namedCause() {
        return this.namedCause;
    }

    @Generated
    public Collection<String> defaultsUsed() {
        return this.defaultsUsed;
    }

    @Generated
    public Collection<String> affectedEntityTypes() {
        return this.affectedEntityTypes;
    }

    @Generated
    public Collection<String> causeEntityTypes() {
        return this.causeEntityTypes;
    }

    @Generated
    public boolean grouped() {
        return this.grouped;
    }

    @Generated
    public int limit() {
        return this.limit;
    }

    @Generated
    public Coordinate coordinate() {
        return this.coordinate;
    }

    @Generated
    public boolean lookup() {
        return this.lookup;
    }

    @Generated
    public Collection<String> affectedMaterials() {
        return this.affectedMaterials;
    }

    @Generated
    public Coordinate maxCoordinate() {
        return this.maxCoordinate;
    }

    @Generated
    public Coordinate minCoordinate() {
        return this.minCoordinate;
    }

    @Generated
    public int offset() {
        return this.offset;
    }

    @Generated
    public Collection<String> affectedPlayerNames() {
        return this.affectedPlayerNames;
    }

    @Generated
    public Collection<String> causePlayerNames() {
        return this.causePlayerNames;
    }

    @Generated
    public String descriptor() {
        return this.descriptor;
    }

    @Generated
    public Coordinate referenceCoordinate() {
        return this.referenceCoordinate;
    }

    @Generated
    public Boolean reversed() {
        return this.reversed;
    }

    @Generated
    public Sort sort() {
        return this.sort;
    }

    @Generated
    public UUID worldUuid() {
        return this.worldUuid;
    }

    @Generated
    public String toString() {
        return "ActivityQuery(actionTypeKeys=" + String.valueOf(this.actionTypeKeys()) + ", actionTypes=" + String.valueOf(this.actionTypes()) + ", activityIds=" + String.valueOf(this.activityIds()) + ", after=" + this.after() + ", before=" + this.before() + ", affectedBlocks=" + String.valueOf(this.affectedBlocks()) + ", causeBlocks=" + String.valueOf(this.causeBlocks()) + ", namedCause=" + this.namedCause() + ", defaultsUsed=" + String.valueOf(this.defaultsUsed()) + ", affectedEntityTypes=" + String.valueOf(this.affectedEntityTypes()) + ", causeEntityTypes=" + String.valueOf(this.causeEntityTypes()) + ", grouped=" + this.grouped() + ", limit=" + this.limit() + ", coordinate=" + String.valueOf(this.coordinate()) + ", lookup=" + this.lookup() + ", affectedMaterials=" + String.valueOf(this.affectedMaterials()) + ", maxCoordinate=" + String.valueOf(this.maxCoordinate()) + ", minCoordinate=" + String.valueOf(this.minCoordinate()) + ", offset=" + this.offset() + ", affectedPlayerNames=" + String.valueOf(this.affectedPlayerNames()) + ", causePlayerNames=" + String.valueOf(this.causePlayerNames()) + ", descriptor=" + this.descriptor() + ", referenceCoordinate=" + String.valueOf(this.referenceCoordinate()) + ", reversed=" + this.reversed() + ", sort=" + String.valueOf((Object)this.sort()) + ", worldUuid=" + String.valueOf(this.worldUuid()) + ")";
    }

    public static enum Sort {
        ASCENDING,
        DESCENDING;

    }

    public static abstract class ActivityQueryBuilder<C extends ActivityQuery, B extends ActivityQueryBuilder<C, B>> {
        @Generated
        private ArrayList<String> actionTypeKeys;
        @Generated
        private ArrayList<ActionType> actionTypes;
        @Generated
        private Collection<Integer> activityIds;
        @Generated
        private Long after;
        @Generated
        private Long before;
        @Generated
        private ArrayList<String> affectedBlocks;
        @Generated
        private ArrayList<String> causeBlocks;
        @Generated
        private String namedCause;
        @Generated
        private ArrayList<String> defaultsUsed;
        @Generated
        private ArrayList<String> affectedEntityTypes;
        @Generated
        private ArrayList<String> causeEntityTypes;
        @Generated
        private boolean grouped$set;
        @Generated
        private boolean grouped$value;
        @Generated
        private int limit;
        @Generated
        private Coordinate coordinate;
        @Generated
        private boolean lookup$set;
        @Generated
        private boolean lookup$value;
        @Generated
        private ArrayList<String> affectedMaterials;
        @Generated
        private Coordinate maxCoordinate;
        @Generated
        private Coordinate minCoordinate;
        @Generated
        private boolean offset$set;
        @Generated
        private int offset$value;
        @Generated
        private ArrayList<String> affectedPlayerNames;
        @Generated
        private ArrayList<String> causePlayerNames;
        @Generated
        private String descriptor;
        @Generated
        private Coordinate referenceCoordinate;
        @Generated
        private Boolean reversed;
        @Generated
        private boolean sort$set;
        @Generated
        private Sort sort$value;
        @Generated
        private UUID worldUuid;

        public B activityId(int activityId) {
            if (this.activityIds == null) {
                this.activityIds = new ArrayList<Integer>();
            }
            this.activityIds.add(activityId);
            return this.self();
        }

        public B boundingCoordinates(Coordinate minCoordinate, Coordinate maxCoordinate) {
            this.minCoordinate = minCoordinate;
            this.maxCoordinate = maxCoordinate;
            return this.self();
        }

        public B coordinate(double x, double y, double z) {
            this.coordinate = new Coordinate(x, y, z);
            return this.self();
        }

        public B coordinateFromReferenceCoordinate() {
            this.coordinate = this.referenceCoordinate;
            return this.self();
        }

        public B modification() {
            this.lookup(false);
            this.grouped(false);
            return this.self();
        }

        public B radius(int radius) {
            Coordinate minCoordinate = new Coordinate(this.referenceCoordinate.intX() - radius, this.referenceCoordinate.intY() - radius, this.referenceCoordinate.intZ() - radius);
            Coordinate maxCoordinate = new Coordinate(this.referenceCoordinate.intX() + radius, this.referenceCoordinate.intY() + radius, this.referenceCoordinate.intZ() + radius);
            this.boundingCoordinates(minCoordinate, maxCoordinate);
            return this.self();
        }

        public B restore() {
            this.lookup(false);
            this.grouped(false);
            this.sort(Sort.ASCENDING);
            return this.self();
        }

        public B rollback() {
            this.lookup(false);
            this.grouped(false);
            this.sort(Sort.DESCENDING);
            return this.self();
        }

        @Generated
        protected B $fillValuesFrom(C instance) {
            ActivityQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ActivityQuery instance, ActivityQueryBuilder<?, ?> b) {
            b.actionTypeKeys(instance.actionTypeKeys == null ? Collections.emptyList() : instance.actionTypeKeys);
            b.actionTypes(instance.actionTypes == null ? Collections.emptyList() : instance.actionTypes);
            b.activityIds(instance.activityIds);
            b.after(instance.after);
            b.before(instance.before);
            b.affectedBlocks(instance.affectedBlocks == null ? Collections.emptyList() : instance.affectedBlocks);
            b.causeBlocks(instance.causeBlocks == null ? Collections.emptyList() : instance.causeBlocks);
            b.namedCause(instance.namedCause);
            b.defaultsUsed(instance.defaultsUsed == null ? Collections.emptyList() : instance.defaultsUsed);
            b.affectedEntityTypes(instance.affectedEntityTypes == null ? Collections.emptyList() : instance.affectedEntityTypes);
            b.causeEntityTypes(instance.causeEntityTypes == null ? Collections.emptyList() : instance.causeEntityTypes);
            b.grouped(instance.grouped);
            b.limit(instance.limit);
            b.coordinate(instance.coordinate);
            b.lookup(instance.lookup);
            b.affectedMaterials(instance.affectedMaterials == null ? Collections.emptyList() : instance.affectedMaterials);
            b.maxCoordinate(instance.maxCoordinate);
            b.minCoordinate(instance.minCoordinate);
            b.offset(instance.offset);
            b.affectedPlayerNames(instance.affectedPlayerNames == null ? Collections.emptyList() : instance.affectedPlayerNames);
            b.causePlayerNames(instance.causePlayerNames == null ? Collections.emptyList() : instance.causePlayerNames);
            b.descriptor(instance.descriptor);
            b.referenceCoordinate(instance.referenceCoordinate);
            b.reversed(instance.reversed);
            b.sort(instance.sort);
            b.worldUuid(instance.worldUuid);
        }

        @Generated
        public B actionTypeKey(String actionTypeKey) {
            if (this.actionTypeKeys == null) {
                this.actionTypeKeys = new ArrayList();
            }
            this.actionTypeKeys.add(actionTypeKey);
            return this.self();
        }

        @Generated
        public B actionTypeKeys(Collection<? extends String> actionTypeKeys) {
            if (actionTypeKeys == null) {
                throw new NullPointerException("actionTypeKeys cannot be null");
            }
            if (this.actionTypeKeys == null) {
                this.actionTypeKeys = new ArrayList();
            }
            this.actionTypeKeys.addAll(actionTypeKeys);
            return this.self();
        }

        @Generated
        public B clearActionTypeKeys() {
            if (this.actionTypeKeys != null) {
                this.actionTypeKeys.clear();
            }
            return this.self();
        }

        @Generated
        public B actionType(ActionType actionType) {
            if (this.actionTypes == null) {
                this.actionTypes = new ArrayList();
            }
            this.actionTypes.add(actionType);
            return this.self();
        }

        @Generated
        public B actionTypes(Collection<? extends ActionType> actionTypes) {
            if (actionTypes == null) {
                throw new NullPointerException("actionTypes cannot be null");
            }
            if (this.actionTypes == null) {
                this.actionTypes = new ArrayList();
            }
            this.actionTypes.addAll(actionTypes);
            return this.self();
        }

        @Generated
        public B clearActionTypes() {
            if (this.actionTypes != null) {
                this.actionTypes.clear();
            }
            return this.self();
        }

        @Generated
        public B activityIds(Collection<Integer> activityIds) {
            this.activityIds = activityIds;
            return this.self();
        }

        @Generated
        public B after(Long after) {
            this.after = after;
            return this.self();
        }

        @Generated
        public B before(Long before) {
            this.before = before;
            return this.self();
        }

        @Generated
        public B affectedBlock(String affectedBlock) {
            if (this.affectedBlocks == null) {
                this.affectedBlocks = new ArrayList();
            }
            this.affectedBlocks.add(affectedBlock);
            return this.self();
        }

        @Generated
        public B affectedBlocks(Collection<? extends String> affectedBlocks) {
            if (affectedBlocks == null) {
                throw new NullPointerException("affectedBlocks cannot be null");
            }
            if (this.affectedBlocks == null) {
                this.affectedBlocks = new ArrayList();
            }
            this.affectedBlocks.addAll(affectedBlocks);
            return this.self();
        }

        @Generated
        public B clearAffectedBlocks() {
            if (this.affectedBlocks != null) {
                this.affectedBlocks.clear();
            }
            return this.self();
        }

        @Generated
        public B causeBlock(String causeBlock) {
            if (this.causeBlocks == null) {
                this.causeBlocks = new ArrayList();
            }
            this.causeBlocks.add(causeBlock);
            return this.self();
        }

        @Generated
        public B causeBlocks(Collection<? extends String> causeBlocks) {
            if (causeBlocks == null) {
                throw new NullPointerException("causeBlocks cannot be null");
            }
            if (this.causeBlocks == null) {
                this.causeBlocks = new ArrayList();
            }
            this.causeBlocks.addAll(causeBlocks);
            return this.self();
        }

        @Generated
        public B clearCauseBlocks() {
            if (this.causeBlocks != null) {
                this.causeBlocks.clear();
            }
            return this.self();
        }

        @Generated
        public B namedCause(String namedCause) {
            this.namedCause = namedCause;
            return this.self();
        }

        @Generated
        public B defaultUsed(String defaultUsed) {
            if (this.defaultsUsed == null) {
                this.defaultsUsed = new ArrayList();
            }
            this.defaultsUsed.add(defaultUsed);
            return this.self();
        }

        @Generated
        public B defaultsUsed(Collection<? extends String> defaultsUsed) {
            if (defaultsUsed == null) {
                throw new NullPointerException("defaultsUsed cannot be null");
            }
            if (this.defaultsUsed == null) {
                this.defaultsUsed = new ArrayList();
            }
            this.defaultsUsed.addAll(defaultsUsed);
            return this.self();
        }

        @Generated
        public B clearDefaultsUsed() {
            if (this.defaultsUsed != null) {
                this.defaultsUsed.clear();
            }
            return this.self();
        }

        @Generated
        public B affectedEntityType(String affectedEntityType) {
            if (this.affectedEntityTypes == null) {
                this.affectedEntityTypes = new ArrayList();
            }
            this.affectedEntityTypes.add(affectedEntityType);
            return this.self();
        }

        @Generated
        public B affectedEntityTypes(Collection<? extends String> affectedEntityTypes) {
            if (affectedEntityTypes == null) {
                throw new NullPointerException("affectedEntityTypes cannot be null");
            }
            if (this.affectedEntityTypes == null) {
                this.affectedEntityTypes = new ArrayList();
            }
            this.affectedEntityTypes.addAll(affectedEntityTypes);
            return this.self();
        }

        @Generated
        public B clearAffectedEntityTypes() {
            if (this.affectedEntityTypes != null) {
                this.affectedEntityTypes.clear();
            }
            return this.self();
        }

        @Generated
        public B causeEntityType(String causeEntityType) {
            if (this.causeEntityTypes == null) {
                this.causeEntityTypes = new ArrayList();
            }
            this.causeEntityTypes.add(causeEntityType);
            return this.self();
        }

        @Generated
        public B causeEntityTypes(Collection<? extends String> causeEntityTypes) {
            if (causeEntityTypes == null) {
                throw new NullPointerException("causeEntityTypes cannot be null");
            }
            if (this.causeEntityTypes == null) {
                this.causeEntityTypes = new ArrayList();
            }
            this.causeEntityTypes.addAll(causeEntityTypes);
            return this.self();
        }

        @Generated
        public B clearCauseEntityTypes() {
            if (this.causeEntityTypes != null) {
                this.causeEntityTypes.clear();
            }
            return this.self();
        }

        @Generated
        public B grouped(boolean grouped) {
            this.grouped$value = grouped;
            this.grouped$set = true;
            return this.self();
        }

        @Generated
        public B limit(int limit) {
            this.limit = limit;
            return this.self();
        }

        @Generated
        public B coordinate(Coordinate coordinate) {
            this.coordinate = coordinate;
            return this.self();
        }

        @Generated
        public B lookup(boolean lookup) {
            this.lookup$value = lookup;
            this.lookup$set = true;
            return this.self();
        }

        @Generated
        public B affectedMaterial(String affectedMaterial) {
            if (this.affectedMaterials == null) {
                this.affectedMaterials = new ArrayList();
            }
            this.affectedMaterials.add(affectedMaterial);
            return this.self();
        }

        @Generated
        public B affectedMaterials(Collection<? extends String> affectedMaterials) {
            if (affectedMaterials == null) {
                throw new NullPointerException("affectedMaterials cannot be null");
            }
            if (this.affectedMaterials == null) {
                this.affectedMaterials = new ArrayList();
            }
            this.affectedMaterials.addAll(affectedMaterials);
            return this.self();
        }

        @Generated
        public B clearAffectedMaterials() {
            if (this.affectedMaterials != null) {
                this.affectedMaterials.clear();
            }
            return this.self();
        }

        @Generated
        public B maxCoordinate(Coordinate maxCoordinate) {
            this.maxCoordinate = maxCoordinate;
            return this.self();
        }

        @Generated
        public B minCoordinate(Coordinate minCoordinate) {
            this.minCoordinate = minCoordinate;
            return this.self();
        }

        @Generated
        public B offset(int offset) {
            this.offset$value = offset;
            this.offset$set = true;
            return this.self();
        }

        @Generated
        public B affectedPlayerName(String affectedPlayerName) {
            if (this.affectedPlayerNames == null) {
                this.affectedPlayerNames = new ArrayList();
            }
            this.affectedPlayerNames.add(affectedPlayerName);
            return this.self();
        }

        @Generated
        public B affectedPlayerNames(Collection<? extends String> affectedPlayerNames) {
            if (affectedPlayerNames == null) {
                throw new NullPointerException("affectedPlayerNames cannot be null");
            }
            if (this.affectedPlayerNames == null) {
                this.affectedPlayerNames = new ArrayList();
            }
            this.affectedPlayerNames.addAll(affectedPlayerNames);
            return this.self();
        }

        @Generated
        public B clearAffectedPlayerNames() {
            if (this.affectedPlayerNames != null) {
                this.affectedPlayerNames.clear();
            }
            return this.self();
        }

        @Generated
        public B causePlayerName(String causePlayerName) {
            if (this.causePlayerNames == null) {
                this.causePlayerNames = new ArrayList();
            }
            this.causePlayerNames.add(causePlayerName);
            return this.self();
        }

        @Generated
        public B causePlayerNames(Collection<? extends String> causePlayerNames) {
            if (causePlayerNames == null) {
                throw new NullPointerException("causePlayerNames cannot be null");
            }
            if (this.causePlayerNames == null) {
                this.causePlayerNames = new ArrayList();
            }
            this.causePlayerNames.addAll(causePlayerNames);
            return this.self();
        }

        @Generated
        public B clearCausePlayerNames() {
            if (this.causePlayerNames != null) {
                this.causePlayerNames.clear();
            }
            return this.self();
        }

        @Generated
        public B descriptor(String descriptor) {
            this.descriptor = descriptor;
            return this.self();
        }

        @Generated
        public B referenceCoordinate(Coordinate referenceCoordinate) {
            this.referenceCoordinate = referenceCoordinate;
            return this.self();
        }

        @Generated
        public B reversed(Boolean reversed) {
            this.reversed = reversed;
            return this.self();
        }

        @Generated
        public B sort(Sort sort) {
            this.sort$value = sort;
            this.sort$set = true;
            return this.self();
        }

        @Generated
        public B worldUuid(UUID worldUuid) {
            this.worldUuid = worldUuid;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ActivityQuery.ActivityQueryBuilder(actionTypeKeys=" + String.valueOf(this.actionTypeKeys) + ", actionTypes=" + String.valueOf(this.actionTypes) + ", activityIds=" + String.valueOf(this.activityIds) + ", after=" + this.after + ", before=" + this.before + ", affectedBlocks=" + String.valueOf(this.affectedBlocks) + ", causeBlocks=" + String.valueOf(this.causeBlocks) + ", namedCause=" + this.namedCause + ", defaultsUsed=" + String.valueOf(this.defaultsUsed) + ", affectedEntityTypes=" + String.valueOf(this.affectedEntityTypes) + ", causeEntityTypes=" + String.valueOf(this.causeEntityTypes) + ", grouped$value=" + this.grouped$value + ", limit=" + this.limit + ", coordinate=" + String.valueOf(this.coordinate) + ", lookup$value=" + this.lookup$value + ", affectedMaterials=" + String.valueOf(this.affectedMaterials) + ", maxCoordinate=" + String.valueOf(this.maxCoordinate) + ", minCoordinate=" + String.valueOf(this.minCoordinate) + ", offset$value=" + this.offset$value + ", affectedPlayerNames=" + String.valueOf(this.affectedPlayerNames) + ", causePlayerNames=" + String.valueOf(this.causePlayerNames) + ", descriptor=" + this.descriptor + ", referenceCoordinate=" + String.valueOf(this.referenceCoordinate) + ", reversed=" + this.reversed + ", sort$value=" + String.valueOf((Object)this.sort$value) + ", worldUuid=" + String.valueOf(this.worldUuid) + ")";
        }
    }

    @Generated
    private static final class ActivityQueryBuilderImpl
    extends ActivityQueryBuilder<ActivityQuery, ActivityQueryBuilderImpl> {
        @Generated
        private ActivityQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected ActivityQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ActivityQuery build() {
            return new ActivityQuery(this);
        }
    }
}

