/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.api.services.modifications;

import lombok.Generated;
import lombok.NonNull;
import org.prism_mc.prism.api.activities.Activity;
import org.prism_mc.prism.api.services.modifications.ModificationPartialReason;
import org.prism_mc.prism.api.services.modifications.ModificationQueueMode;
import org.prism_mc.prism.api.services.modifications.ModificationResultStatus;
import org.prism_mc.prism.api.services.modifications.ModificationSkipReason;
import org.prism_mc.prism.api.services.modifications.StateChange;

public final class ModificationResult {
    @NonNull
    private final Activity activity;
    private final ModificationPartialReason partialReason;
    private final StateChange<?> stateChange;
    @NonNull
    private final ModificationResultStatus status;
    private final ModificationSkipReason skipReason;
    private final String target;

    @Generated
    private static ModificationPartialReason $default$partialReason() {
        return ModificationPartialReason.BLACKLISTED;
    }

    @Generated
    private static ModificationResultStatus $default$status() {
        return ModificationResultStatus.SKIPPED;
    }

    @Generated
    private static ModificationSkipReason $default$skipReason() {
        return ModificationSkipReason.NOT_IMPLEMENTED;
    }

    @Generated
    ModificationResult(@NonNull Activity activity, ModificationPartialReason partialReason, StateChange<?> stateChange, @NonNull ModificationResultStatus status, ModificationSkipReason skipReason, String target) {
        if (activity == null) {
            throw new NullPointerException("activity is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.activity = activity;
        this.partialReason = partialReason;
        this.stateChange = stateChange;
        this.status = status;
        this.skipReason = skipReason;
        this.target = target;
    }

    @Generated
    public static ModificationResultBuilder builder() {
        return new ModificationResultBuilder();
    }

    @NonNull
    @Generated
    public Activity activity() {
        return this.activity;
    }

    @Generated
    public ModificationPartialReason partialReason() {
        return this.partialReason;
    }

    @Generated
    public StateChange<?> stateChange() {
        return this.stateChange;
    }

    @NonNull
    @Generated
    public ModificationResultStatus status() {
        return this.status;
    }

    @Generated
    public ModificationSkipReason skipReason() {
        return this.skipReason;
    }

    @Generated
    public String target() {
        return this.target;
    }

    public static class ModificationResultBuilder {
        @Generated
        private Activity activity;
        @Generated
        private boolean partialReason$set;
        @Generated
        private ModificationPartialReason partialReason$value;
        @Generated
        private StateChange<?> stateChange;
        @Generated
        private boolean status$set;
        @Generated
        private ModificationResultStatus status$value;
        @Generated
        private boolean skipReason$set;
        @Generated
        private ModificationSkipReason skipReason$value;
        @Generated
        private String target;

        public ModificationResultBuilder applied() {
            this.status(ModificationResultStatus.APPLIED);
            return this;
        }

        public ModificationResultBuilder errored() {
            this.status(ModificationResultStatus.SKIPPED).skipReason(ModificationSkipReason.ERRORED);
            return this;
        }

        public ModificationResultBuilder partial() {
            this.status(ModificationResultStatus.PARTIAL);
            return this;
        }

        public ModificationResultBuilder planned() {
            this.status(ModificationResultStatus.PLANNED);
            return this;
        }

        public ModificationResultBuilder skipped() {
            this.status(ModificationResultStatus.SKIPPED);
            return this;
        }

        public ModificationResultBuilder statusFromMode(ModificationQueueMode mode) {
            if (mode.equals((Object)ModificationQueueMode.PLANNING)) {
                this.planned();
            } else if (mode.equals((Object)ModificationQueueMode.COMPLETING)) {
                this.applied();
            } else {
                this.skipped();
            }
            return this;
        }

        @Generated
        ModificationResultBuilder() {
        }

        @Generated
        public ModificationResultBuilder activity(@NonNull Activity activity) {
            if (activity == null) {
                throw new NullPointerException("activity is marked non-null but is null");
            }
            this.activity = activity;
            return this;
        }

        @Generated
        public ModificationResultBuilder partialReason(ModificationPartialReason partialReason) {
            this.partialReason$value = partialReason;
            this.partialReason$set = true;
            return this;
        }

        @Generated
        public ModificationResultBuilder stateChange(StateChange<?> stateChange) {
            this.stateChange = stateChange;
            return this;
        }

        @Generated
        public ModificationResultBuilder status(@NonNull ModificationResultStatus status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        @Generated
        public ModificationResultBuilder skipReason(ModificationSkipReason skipReason) {
            this.skipReason$value = skipReason;
            this.skipReason$set = true;
            return this;
        }

        @Generated
        public ModificationResultBuilder target(String target) {
            this.target = target;
            return this;
        }

        @Generated
        public ModificationResult build() {
            ModificationPartialReason partialReason$value = this.partialReason$value;
            if (!this.partialReason$set) {
                partialReason$value = ModificationResult.$default$partialReason();
            }
            ModificationResultStatus status$value = this.status$value;
            if (!this.status$set) {
                status$value = ModificationResult.$default$status();
            }
            ModificationSkipReason skipReason$value = this.skipReason$value;
            if (!this.skipReason$set) {
                skipReason$value = ModificationResult.$default$skipReason();
            }
            return new ModificationResult(this.activity, partialReason$value, this.stateChange, status$value, skipReason$value, this.target);
        }

        @Generated
        public String toString() {
            return "ModificationResult.ModificationResultBuilder(activity=" + String.valueOf(this.activity) + ", partialReason$value=" + String.valueOf((Object)this.partialReason$value) + ", stateChange=" + String.valueOf(this.stateChange) + ", status$value=" + String.valueOf((Object)this.status$value) + ", skipReason$value=" + String.valueOf((Object)this.skipReason$value) + ", target=" + this.target + ")";
        }
    }
}

