/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.api.services.pagination;

import java.util.List;
import lombok.Generated;
import org.prism_mc.prism.api.services.pagination.PaginationResult;

public class ListPaginationResult<T>
extends PaginationResult<T> {
    protected final List<T> results;

    public ListPaginationResult(List<T> results, int perPage) {
        this(results, results.size(), perPage, 1);
    }

    public ListPaginationResult(List<T> results, int totalResults, int perPage, int currentPage) {
        super(totalResults, perPage, currentPage);
        this.results = results;
    }

    @Override
    public Iterable<T> currentPageResults() {
        int startIndex = Math.max(0, this.offset());
        int endIndex = Math.min(this.results.size(), startIndex + this.perPage);
        if (startIndex >= this.results.size()) {
            return List.of();
        }
        return this.results.subList(startIndex, endIndex);
    }

    @Generated
    public List<T> results() {
        return this.results;
    }
}

