/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.api.services.pagination;

import lombok.Generated;

public abstract class PaginationResult<T> {
    protected int currentPage;
    protected final int totalResults;
    protected final int perPage;

    public PaginationResult(int totalResults, int perPage, int currentPage) {
        this.currentPage = currentPage;
        this.totalResults = totalResults;
        this.perPage = perPage;
    }

    public abstract Iterable<T> currentPageResults();

    public boolean hasNextPage() {
        return this.currentPage < this.totalPages();
    }

    public boolean hasPrevPage() {
        return this.currentPage > 1;
    }

    public boolean isEmpty() {
        return this.totalResults == 0;
    }

    public int limit() {
        return this.offset() + this.perPage;
    }

    public int limitForPage(int page) {
        return this.offsetForPage(page) + this.perPage;
    }

    public int offset() {
        return this.offsetForPage(this.currentPage);
    }

    public int offsetForPage(int page) {
        return this.perPage * (page - 1);
    }

    public int totalPages() {
        return (int)Math.ceil((double)this.totalResults / (double)this.perPage);
    }

    @Generated
    public int currentPage() {
        return this.currentPage;
    }

    @Generated
    public PaginationResult<T> currentPage(int currentPage) {
        this.currentPage = currentPage;
        return this;
    }

    @Generated
    public int totalResults() {
        return this.totalResults;
    }

    @Generated
    public int perPage() {
        return this.perPage;
    }
}

