/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.ConfigException;
import org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.impl.AbstractConfigNodeValue;
import org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.impl.AbstractConfigValue;
import org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.impl.ConfigReference;
import org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.impl.ConfigString;
import org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.impl.Path;
import org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.impl.PathParser;
import org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.impl.SubstitutionExpression;
import org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.impl.Token;
import org.prism_mc.prism.libs.configurate.hocon.internal.typesafeconfig.impl.Tokens;

final class ConfigNodeSimpleValue
extends AbstractConfigNodeValue {
    final Token token;

    ConfigNodeSimpleValue(Token value) {
        this.token = value;
    }

    @Override
    protected Collection<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    protected Token token() {
        return this.token;
    }

    protected AbstractConfigValue value() {
        if (Tokens.isValue(this.token)) {
            return Tokens.getValue(this.token);
        }
        if (Tokens.isUnquotedText(this.token)) {
            return new ConfigString.Unquoted(this.token.origin(), Tokens.getUnquotedText(this.token));
        }
        if (Tokens.isSubstitution(this.token)) {
            List<Token> expression = Tokens.getSubstitutionPathExpression(this.token);
            Path path = PathParser.parsePathExpression(expression.iterator(), this.token.origin());
            boolean optional = Tokens.getSubstitutionOptional(this.token);
            return new ConfigReference(this.token.origin(), new SubstitutionExpression(path, optional));
        }
        throw new ConfigException.BugOrBroken("ConfigNodeSimpleValue did not contain a valid value token");
    }
}

