/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.libs.configurate.loader;

import java.util.Objects;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.prism_mc.prism.libs.configurate.ConfigurationNode;
import org.prism_mc.prism.libs.configurate.serialize.SerializationException;
import org.prism_mc.prism.libs.kyori.option.Option;
import org.prism_mc.prism.libs.kyori.option.value.ValueSource;

final class ValueSources {
    private ValueSources() {
    }

    public static ValueSource node(ConfigurationNode node) {
        return new Node(Objects.requireNonNull(node, "node"));
    }

    static final class Node
    implements ValueSource {
        private static final Pattern PATH_SPLIT = Pattern.compile("[:/]");
        private final ConfigurationNode source;

        Node(ConfigurationNode source) {
            this.source = source;
        }

        @Override
        public <T> @Nullable T value(Option<T> option) {
            String[] path = PATH_SPLIT.split(option.id(), -1);
            try {
                return this.source.node(path).get(option.valueType().type());
            }
            catch (SerializationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

