/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.libs.configurate.reference;

import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.prism_mc.prism.libs.configurate.ConfigurateException;
import org.prism_mc.prism.libs.configurate.ConfigurationNode;
import org.prism_mc.prism.libs.configurate.ScopedConfigurationNode;
import org.prism_mc.prism.libs.configurate.loader.ConfigurationLoader;
import org.prism_mc.prism.libs.configurate.reactive.Disposable;
import org.prism_mc.prism.libs.configurate.reactive.Subscriber;
import org.prism_mc.prism.libs.configurate.reference.ConfigurationReference;
import org.prism_mc.prism.libs.configurate.reference.ManualConfigurationReference;
import org.prism_mc.prism.libs.configurate.util.UnmodifiableCollections;

class WatchingConfigurationReference<N extends ScopedConfigurationNode<N>>
extends ManualConfigurationReference<N>
implements Subscriber<WatchEvent<?>> {
    private volatile boolean saveSuppressed;
    private @Nullable Disposable disposable;

    WatchingConfigurationReference(ConfigurationLoader<? extends N> loader, Executor taskExecutor) {
        super(loader, taskExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ConfigurationNode newNode) throws ConfigurateException {
        ConfigurationLoader configurationLoader = this.loader();
        synchronized (configurationLoader) {
            try {
                this.saveSuppressed = true;
                super.save(newNode);
            }
            finally {
                this.saveSuppressed = false;
            }
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.disposable != null) {
            this.disposable.dispose();
            this.disposable = null;
        }
    }

    @Override
    public void submit(WatchEvent<?> item) {
        if (!this.saveSuppressed || item.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.LOADING, e));
            }
        }
    }

    @Override
    public void onError(Throwable thrown) {
        this.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.UNKNOWN, thrown));
    }

    @Override
    public void onClose() {
        this.close();
    }

    void disposable(Disposable disposable) {
        this.disposable = disposable;
    }
}

