/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.prism_mc.prism.libs.configurate.objectmapping.ConfigSerializable;
import org.prism_mc.prism.libs.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public class CommandsConfiguration {
    @Comment(value="Allow Minecraft tags in tag parameters. The list is long and often\nincludes tags unlikely to be useful. We instead recommend using\nthe tag whitelist option to reduce the list to something useful.\nNote: disabling this overrides the tag whitelist.")
    private boolean allowMinecraftTags = true;
    @Comment(value="Enable the block tag whitelist. If disabled, values will be ignored.")
    private boolean blockTagWhitelistEnabled = false;
    @Comment(value="Define block tags allowed in the btag parameter (and auto-suggestions).\nThese must include the tag namespace, e.g. `minecraft:dirt`, but can\ninclude any tag - even custom ones.\nhttps://minecraft.wiki/w/Block_tag_(Java_Edition)\nNote: All Minecraft tags will be excluded if `allowMinecraftTags` is false.")
    private List<String> blockTagWhitelist = new ArrayList<String>();
    @Comment(value="Enable the entity type tag whitelist. If disabled, values will be ignored.")
    private boolean entityTypeTagWhitelistEnabled = false;
    @Comment(value="Define entity type tags allowed in the btag parameter (and auto-suggestions).\nThese must include the tag namespace, e.g. `minecraft:aquatic`, but can\ninclude any tag - even custom ones.\nhttps://minecraft.wiki/w/Entity_type_tag_(Java_Edition)\nNote: All Minecraft tags will be excluded if `allowMinecraftTags` is false.")
    private List<String> entityTypeTagWhitelist = new ArrayList<String>();
    @Comment(value="Enable the item tag whitelist. If disabled, values will be ignored.")
    private boolean itemTagWhitelistEnabled = false;
    @Comment(value="Define item tags allowed in the btag parameter (and auto-suggestions).\nThese must include the tag namespace, e.g. `minecraft:dirt`, but can\ninclude any tag - even custom ones.\nhttps://minecraft.wiki/w/Item_tag_(Java_Edition)\nNote: All Minecraft tags will be excluded if `allowMinecraftTags` is false.")
    private List<String> itemTagWhitelist = new ArrayList<String>();

    public CommandsConfiguration() {
        this.blockTagWhitelist.add("minecraft:coal_ores");
        this.blockTagWhitelist.add("minecraft:copper_ores");
        this.blockTagWhitelist.add("minecraft:crops");
        this.blockTagWhitelist.add("minecraft:diamond_ores");
        this.blockTagWhitelist.add("minecraft:emerald_ores");
        this.blockTagWhitelist.add("minecraft:gold_ores");
        this.blockTagWhitelist.add("minecraft:iron_ores");
        this.blockTagWhitelist.add("minecraft:lapis_ores");
        this.blockTagWhitelist.add("minecraft:logs_that_burn");
        this.blockTagWhitelist.add("minecraft:beacon_base_blocks");
        this.blockTagWhitelist.add("minecraft:mineable/axe");
        this.blockTagWhitelist.add("minecraft:mineable/hoe");
        this.blockTagWhitelist.add("minecraft:mineable/pickaxe");
        this.blockTagWhitelist.add("minecraft:mineable/shovel");
        this.blockTagWhitelist.add("minecraft:redstone_ores");
        this.blockTagWhitelist.add("prism:all_ores");
        this.itemTagWhitelist.add("minecraft:axes");
        this.itemTagWhitelist.add("minecraft:beacon_payment_item");
        this.itemTagWhitelist.add("minecraft:bundles");
        this.itemTagWhitelist.add("minecraft:chest_armor");
        this.itemTagWhitelist.add("minecraft:coal_ores");
        this.itemTagWhitelist.add("minecraft:copper_ores");
        this.itemTagWhitelist.add("minecraft:diamond_ores");
        this.itemTagWhitelist.add("minecraft:emerald_ores");
        this.itemTagWhitelist.add("minecraft:foot_armor");
        this.itemTagWhitelist.add("minecraft:gold_ores");
        this.itemTagWhitelist.add("minecraft:head_armor");
        this.itemTagWhitelist.add("minecraft:hoes");
        this.itemTagWhitelist.add("minecraft:iron_ores");
        this.itemTagWhitelist.add("minecraft:lapis_ores");
        this.itemTagWhitelist.add("minecraft:leg_armor");
        this.itemTagWhitelist.add("minecraft:pickaxes");
        this.itemTagWhitelist.add("minecraft:redstone_ores");
        this.itemTagWhitelist.add("minecraft:shovels");
        this.itemTagWhitelist.add("prism:all_armor");
        this.itemTagWhitelist.add("prism:all_ores");
    }

    @Generated
    public boolean allowMinecraftTags() {
        return this.allowMinecraftTags;
    }

    @Generated
    public boolean blockTagWhitelistEnabled() {
        return this.blockTagWhitelistEnabled;
    }

    @Generated
    public List<String> blockTagWhitelist() {
        return this.blockTagWhitelist;
    }

    @Generated
    public boolean entityTypeTagWhitelistEnabled() {
        return this.entityTypeTagWhitelistEnabled;
    }

    @Generated
    public List<String> entityTypeTagWhitelist() {
        return this.entityTypeTagWhitelist;
    }

    @Generated
    public boolean itemTagWhitelistEnabled() {
        return this.itemTagWhitelistEnabled;
    }

    @Generated
    public List<String> itemTagWhitelist() {
        return this.itemTagWhitelist;
    }
}

