/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration;

import java.io.File;
import java.nio.file.Path;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.prism_mc.prism.libs.configurate.ConfigurateException;
import org.prism_mc.prism.libs.configurate.ConfigurationNode;
import org.prism_mc.prism.libs.configurate.hocon.HoconConfigurationLoader;
import org.prism_mc.prism.libs.configurate.loader.ConfigurationLoader;
import org.prism_mc.prism.loader.services.configuration.PrismConfiguration;
import org.prism_mc.prism.loader.services.configuration.serializers.LocaleSerializerConfigurate;
import org.prism_mc.prism.loader.services.configuration.storage.StorageConfiguration;

public class ConfigurationService {
    private final Path dataPath;
    private final Logger logger;
    private PrismConfiguration prismConfiguration = new PrismConfiguration();
    private StorageConfiguration storageConfiguration = new StorageConfiguration();

    public ConfigurationService(Path dataPath, Logger logger) {
        this.dataPath = dataPath;
        this.logger = logger;
        this.loadConfigurations();
    }

    public PrismConfiguration prismConfig() {
        return this.prismConfiguration;
    }

    public StorageConfiguration storageConfig() {
        return this.storageConfiguration;
    }

    public void loadConfigurations() {
        File prismConfigFile = new File(this.dataPath.toFile(), "prism.conf");
        this.prismConfiguration = this.getOrWriteConfiguration(PrismConfiguration.class, prismConfigFile, new PrismConfiguration());
        File storageConfigFile = new File(this.dataPath.toFile(), "storage.conf");
        this.storageConfiguration = this.getOrWriteConfiguration(StorageConfiguration.class, storageConfigFile, new StorageConfiguration());
    }

    public ConfigurationLoader<?> configurationLoader(Path file) {
        HoconConfigurationLoader.Builder builder = HoconConfigurationLoader.builder();
        builder.prettyPrinting(true);
        builder.defaultOptions(opts -> opts.shouldCopyDefaults(true).implicitInitialization(false).serializers(serializerBuilder -> serializerBuilder.register(Locale.class, new LocaleSerializerConfigurate())));
        builder.path(file);
        return builder.build();
    }

    public <T> T getOrWriteConfiguration(Class<T> clz, File file, T defaultConfig) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        ConfigurationLoader<?> loader = this.configurationLoader(file.toPath());
        try {
            Object root = loader.load();
            T config = root.get(clz);
            if (config == null) {
                config = defaultConfig;
            }
            root.set(clz, config);
            loader.save((ConfigurationNode)root);
            return config;
        }
        catch (ConfigurateException e) {
            if (e.getCause() != null) {
                this.logger.log(Level.SEVERE, "An exception occurred", e);
            }
            return null;
        }
    }
}

