/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.prism_mc.prism.libs.configurate.objectmapping.ConfigSerializable;
import org.prism_mc.prism.libs.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public class DefaultsConfiguration {
    @Comment(value="The default radius for the drain command.")
    private int drainRadius = 5;
    @Comment(value="The default radius for the extinguish command.")
    private int extinguishRadius = 5;
    @Comment(value="The default locale for plugin messages. Messages given to players\nwill use their client locale settings.")
    private Locale defaultLocale = Locale.US;
    @Comment(value="Default parameters for lookups, rollbacks, restores. Leave empty for none.")
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    @Comment(value="Sets the default radius to use when searching for nearby activity.")
    private int nearRadius = 5;
    @Comment(value="Limits how many results are shown \"per page\" when doing lookups.")
    private int perPage = 10;

    public DefaultsConfiguration() {
        this.parameters.put("r", "32");
        this.parameters.put("since", "3d");
    }

    @Generated
    public int drainRadius() {
        return this.drainRadius;
    }

    @Generated
    public int extinguishRadius() {
        return this.extinguishRadius;
    }

    @Generated
    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    @Generated
    public Map<String, String> parameters() {
        return this.parameters;
    }

    @Generated
    public int nearRadius() {
        return this.nearRadius;
    }

    @Generated
    public int perPage() {
        return this.perPage;
    }
}

