/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.prism_mc.prism.api.services.modifications.ModificationRuleset;
import org.prism_mc.prism.libs.configurate.objectmapping.ConfigSerializable;
import org.prism_mc.prism.libs.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public class ModificationConfiguration {
    @Comment(value="List materials that should be excluded from modifications.")
    private List<String> blockBlacklist = new ArrayList<String>();
    @Comment(value="Enables draining lava from the modification area.")
    private boolean drainLava = true;
    @Comment(value="List entities that should be excluded from modifications.")
    private List<String> entityBlacklist = new ArrayList<String>();
    @Comment(value="Set a maximum number of modifications per task. Splitting up world changes\ncan help avoid overloading individual ticks and causing lag.\nThis can also reduce client lag as fewer changes are sent to clients at once.")
    private int maxPerTask = 1000;
    @Comment(value="Teleport entities out of the way.")
    private boolean moveEntities = true;
    @Comment(value="A list of (typically unsafe) blocks to remove before a modification occurs.")
    private List<String> removeBlocks = new ArrayList<String>();
    @Comment(value="Enables clearing item/xp drops from a modification area.")
    private boolean removeDrops = true;
    @Comment(value="The delay in ticks between modification tasks.")
    private long taskDelay = 5L;

    public ModificationConfiguration() {
        this.blockBlacklist.add("bedrock");
        this.blockBlacklist.add("fire");
        this.blockBlacklist.add("lava");
        this.blockBlacklist.add("tnt");
        this.entityBlacklist.add("creeper");
        this.entityBlacklist.add("tnt_minecart");
        this.entityBlacklist.add("wither");
        this.removeBlocks.add("tnt");
        this.removeBlocks.add("fire");
    }

    public ModificationRuleset.ModificationRulesetBuilder toRulesetBuilder() {
        return ModificationRuleset.builder().blockBlacklist(this.blockBlacklist).drainLava(this.drainLava).entityBlacklist(this.entityBlacklist).maxPerTask(this.maxPerTask).moveEntities(this.moveEntities).removeBlocks(this.removeBlocks).removeDrops(this.removeDrops).taskDelay(this.taskDelay);
    }

    @Generated
    public List<String> blockBlacklist() {
        return this.blockBlacklist;
    }

    @Generated
    public boolean drainLava() {
        return this.drainLava;
    }

    @Generated
    public List<String> entityBlacklist() {
        return this.entityBlacklist;
    }

    @Generated
    public int maxPerTask() {
        return this.maxPerTask;
    }

    @Generated
    public boolean moveEntities() {
        return this.moveEntities;
    }

    @Generated
    public List<String> removeBlocks() {
        return this.removeBlocks;
    }

    @Generated
    public boolean removeDrops() {
        return this.removeDrops;
    }

    @Generated
    public long taskDelay() {
        return this.taskDelay;
    }
}

