/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.prism_mc.prism.libs.configurate.objectmapping.ConfigSerializable;
import org.prism_mc.prism.libs.configurate.objectmapping.meta.Comment;
import org.prism_mc.prism.loader.services.configuration.ActionsConfiguration;
import org.prism_mc.prism.loader.services.configuration.ActivitiesConfiguration;
import org.prism_mc.prism.loader.services.configuration.CommandsConfiguration;
import org.prism_mc.prism.loader.services.configuration.DefaultsConfiguration;
import org.prism_mc.prism.loader.services.configuration.ModificationConfiguration;
import org.prism_mc.prism.loader.services.configuration.RecordingConfiguration;
import org.prism_mc.prism.loader.services.configuration.alerts.AlertsConfiguration;
import org.prism_mc.prism.loader.services.configuration.cache.CacheConfiguration;
import org.prism_mc.prism.loader.services.configuration.filters.FilterConfiguration;
import org.prism_mc.prism.loader.services.configuration.purge.PurgeConfiguration;

@ConfigSerializable
public class PrismConfiguration {
    @Comment(value="Actions are in-game events/changes that Prism can record data for.\nSome are purely informational, some can be reversed/restored.\nDisabling any here will completely prevent prism from recording them.\nActions that are disabled by default may need some consideration/filters\nbefore enabling them. Blanket-enabling everything is a recipe for\nexponential database growth.")
    private ActionsConfiguration actions = new ActionsConfiguration();
    @Comment(value="Activities represent an action, location, cause, timestamp, etc.")
    private ActivitiesConfiguration activities = new ActivitiesConfiguration();
    private AlertsConfiguration alerts = new AlertsConfiguration();
    @Comment(value="Configure how Prism caches data. Probably best to leave\nthese settings alone unless you have specific reasons to change them.")
    private CacheConfiguration cache = new CacheConfiguration();
    private CommandsConfiguration commands = new CommandsConfiguration();
    @Comment(value="Enable plugin debug mode. Produces extra logging to help diagnose issues.")
    private boolean debug = false;
    @Comment(value="Enable filter debug mode. Logs details about every event and filter matching.")
    private boolean debugFilters = false;
    private DefaultsConfiguration defaults = new DefaultsConfiguration();
    @Comment(value="Filters allow fine-grained control over what prism records.\nPlease see https://docs.prism-mc.org/configs/filters/")
    private List<FilterConfiguration> filters = new ArrayList<FilterConfiguration>();
    @Comment(value="Configure rules for modifications (rollbacks/restores).")
    private ModificationConfiguration modifications = new ModificationConfiguration();
    private PurgeConfiguration purges = new PurgeConfiguration();
    private RecordingConfiguration recording = new RecordingConfiguration();

    @Generated
    public ActionsConfiguration actions() {
        return this.actions;
    }

    @Generated
    public ActivitiesConfiguration activities() {
        return this.activities;
    }

    @Generated
    public AlertsConfiguration alerts() {
        return this.alerts;
    }

    @Generated
    public CacheConfiguration cache() {
        return this.cache;
    }

    @Generated
    public CommandsConfiguration commands() {
        return this.commands;
    }

    @Generated
    public boolean debug() {
        return this.debug;
    }

    @Generated
    public boolean debugFilters() {
        return this.debugFilters;
    }

    @Generated
    public DefaultsConfiguration defaults() {
        return this.defaults;
    }

    @Generated
    public List<FilterConfiguration> filters() {
        return this.filters;
    }

    @Generated
    public ModificationConfiguration modifications() {
        return this.modifications;
    }

    @Generated
    public PurgeConfiguration purges() {
        return this.purges;
    }

    @Generated
    public RecordingConfiguration recording() {
        return this.recording;
    }
}

