/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration.cache;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.prism_mc.prism.libs.configurate.objectmapping.ConfigSerializable;
import org.prism_mc.prism.libs.configurate.objectmapping.meta.Comment;
import org.prism_mc.prism.loader.services.configuration.cache.CacheBuilderConfiguration;
import org.prism_mc.prism.loader.services.configuration.cache.DurationConfiguration;

@ConfigSerializable
public class CacheConfiguration {
    @Comment(value="Enable stats recording. Ideally not used on live servers.")
    private boolean recordStats = false;
    @Comment(value="Cache settings for alerts.")
    private CacheBuilderConfiguration alerts = new CacheBuilderConfiguration(1000L, new DurationConfiguration(5L, TimeUnit.MINUTES));
    @Comment(value="Cache settings for alerted vein locations.")
    private CacheBuilderConfiguration alertedLocations = new CacheBuilderConfiguration(1000L, new DurationConfiguration(5L, TimeUnit.MINUTES));
    @Comment(value="Activity queries (lookups) are cached so that they can be re-used or paginated.")
    private CacheBuilderConfiguration lookupExpiration = new CacheBuilderConfiguration(3L, new DurationConfiguration(5L, TimeUnit.MINUTES));
    @Comment(value="Cache settings for default entity nbt data.")
    private CacheBuilderConfiguration nbtEntityDefaults = new CacheBuilderConfiguration(200L, new DurationConfiguration(15L, TimeUnit.MINUTES));
    @Comment(value="Cache settings for action key/primary keys.")
    private CacheBuilderConfiguration pkCacheActionKey = new CacheBuilderConfiguration(100L);
    @Comment(value="Cache settings for block data/primary keys.")
    private CacheBuilderConfiguration pkCacheBlockData = new CacheBuilderConfiguration(500L, new DurationConfiguration(15L, TimeUnit.MINUTES));
    @Comment(value="Cache settings for entity types/primary keys.")
    private CacheBuilderConfiguration pkCacheEntityType = new CacheBuilderConfiguration(200L);
    @Comment(value="Cache settings for item data/primary keys.")
    private CacheBuilderConfiguration pkCacheItemData = new CacheBuilderConfiguration(1000L, new DurationConfiguration(15L, TimeUnit.MINUTES));
    @Comment(value="Cache settings for named causes/primary keys.")
    private CacheBuilderConfiguration pkCacheNamedCause = new CacheBuilderConfiguration(200L, new DurationConfiguration(15L, TimeUnit.MINUTES));
    @Comment(value="Cache settings for players/primary keys.")
    private CacheBuilderConfiguration pkCachePlayer = new CacheBuilderConfiguration(100L, new DurationConfiguration(15L, TimeUnit.MINUTES));
    @Comment(value="Cache settings for world/primary keys.")
    private CacheBuilderConfiguration pkCacheWorld = new CacheBuilderConfiguration(20L);

    @Generated
    public boolean recordStats() {
        return this.recordStats;
    }

    @Generated
    public CacheBuilderConfiguration alerts() {
        return this.alerts;
    }

    @Generated
    public CacheBuilderConfiguration alertedLocations() {
        return this.alertedLocations;
    }

    @Generated
    public CacheBuilderConfiguration lookupExpiration() {
        return this.lookupExpiration;
    }

    @Generated
    public CacheBuilderConfiguration nbtEntityDefaults() {
        return this.nbtEntityDefaults;
    }

    @Generated
    public CacheBuilderConfiguration pkCacheActionKey() {
        return this.pkCacheActionKey;
    }

    @Generated
    public CacheBuilderConfiguration pkCacheBlockData() {
        return this.pkCacheBlockData;
    }

    @Generated
    public CacheBuilderConfiguration pkCacheEntityType() {
        return this.pkCacheEntityType;
    }

    @Generated
    public CacheBuilderConfiguration pkCacheItemData() {
        return this.pkCacheItemData;
    }

    @Generated
    public CacheBuilderConfiguration pkCacheNamedCause() {
        return this.pkCacheNamedCause;
    }

    @Generated
    public CacheBuilderConfiguration pkCachePlayer() {
        return this.pkCachePlayer;
    }

    @Generated
    public CacheBuilderConfiguration pkCacheWorld() {
        return this.pkCacheWorld;
    }
}

