/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration.purge;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.prism_mc.prism.libs.configurate.objectmapping.ConfigSerializable;
import org.prism_mc.prism.libs.configurate.objectmapping.meta.Comment;
import org.prism_mc.prism.loader.services.configuration.cache.DurationConfiguration;
import org.prism_mc.prism.loader.services.configuration.purge.CommandScheduleConfiguration;

@ConfigSerializable
public class PurgeConfiguration {
    @Comment(value="Set the maximum number of records to delete in each \"purge batch\".\nDeleting records often locks every affected row which can block other\nqueries or new data waiting for insert. If purging is causing performance\nissues or errors in the console, lower this value.\nPlease see https://docs.prism-mc.org/features/purges/ for more.\n")
    private int limit = 5000;
    @Comment(value="Configure the delay between purge cycles. Adding a delay helps break up\nthe purge queries over time, which helps avoid purges dominating the db.\n")
    private DurationConfiguration cycleDelay = new DurationConfiguration(2L, TimeUnit.SECONDS);
    private List<CommandScheduleConfiguration> commandSchedules = new ArrayList<CommandScheduleConfiguration>();

    public PurgeConfiguration() {
        this.commandSchedules.add(new CommandScheduleConfiguration());
    }

    @Generated
    public int limit() {
        return this.limit;
    }

    @Generated
    public DurationConfiguration cycleDelay() {
        return this.cycleDelay;
    }

    @Generated
    public List<CommandScheduleConfiguration> commandSchedules() {
        return this.commandSchedules;
    }
}

