/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration.serializers;

import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.prism_mc.prism.libs.configurate.ConfigurationNode;
import org.prism_mc.prism.libs.configurate.serialize.SerializationException;
import org.prism_mc.prism.libs.configurate.serialize.TypeSerializer;

public class LocaleSerializerConfigurate
implements TypeSerializer<Locale> {
    @Override
    public Locale deserialize(Type type, ConfigurationNode node) {
        @Nullable String value = node.getString();
        if (value == null) {
            return Locale.ENGLISH;
        }
        return Objects.requireNonNull(LocaleSerializerConfigurate.parseLocale(value), "value locale cannot be null!");
    }

    @Override
    public void serialize(Type type, @Nullable Locale obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
        } else {
            node.set(obj.toString());
        }
    }

    private static Locale parseLocale(String string) {
        String[] segments = string.split("_", 3);
        int length = segments.length;
        if (length == 1) {
            return new Locale(string);
        }
        if (length == 2) {
            return new Locale(segments[0], segments[1]);
        }
        if (length == 3) {
            return new Locale(segments[0], segments[1], segments[2]);
        }
        return null;
    }
}

