/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration.storage;

import lombok.Generated;
import org.prism_mc.prism.libs.configurate.objectmapping.ConfigSerializable;
import org.prism_mc.prism.libs.configurate.objectmapping.meta.Comment;
import org.prism_mc.prism.loader.services.configuration.storage.SqlDataSourceConfiguration;

@ConfigSerializable
public class MysqlDataSourceConfiguration
extends SqlDataSourceConfiguration {
    @Comment(value="Toggle recommended Hikari datasource optimizations.\nYou can read about these here: https://github.com/brettwooldridge/HikariCP/wiki/MySQL-Configuration")
    private boolean useHikariOptimizations = true;
    @Comment(value="Enable stored procedures. Stored procedures allow Prism to modify database records\nmore efficiently and with reduced network traffic.\nHowever, your account must have privileges to `CREATE ROUTINE`.\nIf you use a shared database, you likely do NOT have such permission.\nIf you're unsure, Prism tells you in the server console during server startup.\nPrism will force disable this setting if you do not have necessary permission.")
    private boolean useStoredProcedures = true;

    public MysqlDataSourceConfiguration() {
        super("3306", "root");
    }

    public void disallowStoredProcedures() {
        this.useStoredProcedures = false;
    }

    @Generated
    public boolean useHikariOptimizations() {
        return this.useHikariOptimizations;
    }

    @Generated
    public boolean useStoredProcedures() {
        return this.useStoredProcedures;
    }
}

