/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration.storage;

import lombok.Generated;
import org.prism_mc.prism.libs.configurate.objectmapping.ConfigSerializable;
import org.prism_mc.prism.libs.configurate.objectmapping.meta.Comment;
import org.prism_mc.prism.loader.services.configuration.storage.SqlDataSourceConfiguration;

@ConfigSerializable
public class PostgresDataSourceConfiguration
extends SqlDataSourceConfiguration {
    @Comment(value="Set the schema for prism tables/functions to use.\nWe recommend creating a \"prism\" schema for all prism entities.\nhttps://neon.tech/postgresql/postgresql-administration/postgresql-create-schema")
    public String schema = "prism";
    @Comment(value="Enable stored procedures. Stored procedures allow Prism to modify database records\nmore efficiently and with reduced network traffic.\nHowever, your postgres account must have privileges to `CREATE FUNCTION`.\nIf you're unsure, Prism tells you in the server console during server startup.\nPrism will force disable this setting if you do not have necessary permission.")
    private boolean useStoredProcedures = true;

    public PostgresDataSourceConfiguration() {
        super("5432", "postgres");
    }

    @Override
    public String catalog() {
        return this.database();
    }

    public void disallowStoredProcedures() {
        this.useStoredProcedures = false;
    }

    @Override
    @Generated
    public String schema() {
        return this.schema;
    }

    @Generated
    public boolean useStoredProcedures() {
        return this.useStoredProcedures;
    }
}

