/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.configuration.storage;

import lombok.Generated;
import org.prism_mc.prism.libs.configurate.objectmapping.ConfigSerializable;
import org.prism_mc.prism.libs.configurate.objectmapping.meta.Comment;
import org.prism_mc.prism.loader.services.configuration.storage.DataSourceConfiguration;
import org.prism_mc.prism.loader.services.configuration.storage.FileDataSourceConfiguration;
import org.prism_mc.prism.loader.services.configuration.storage.MysqlDataSourceConfiguration;
import org.prism_mc.prism.loader.services.configuration.storage.PostgresDataSourceConfiguration;
import org.prism_mc.prism.loader.services.configuration.storage.SqliteDataSourceConfiguration;
import org.prism_mc.prism.loader.storage.StorageType;

@ConfigSerializable
public class StorageConfiguration {
    @Comment(value="Enable query spy. This logs queries and helpful debug information.\nUsed primarily for development and debugging. Use carefully.")
    private boolean spy = false;
    @Comment(value="Set which storage system to use.\nAvailable options: H2, MARIADB, MYSQL, POSTGRES, SQLITE\nNOTE: Only one storage system may be used at a time.\nTransferring data from one to another is not yet supported.")
    private StorageType primaryStorageType = StorageType.SQLITE;
    @Comment(value="Settings for H2 file-based databases. File-based databases aren't generally\nrecommended but the pros/cons depend entirely on your usage and needs.")
    private FileDataSourceConfiguration h2 = new FileDataSourceConfiguration();
    @Comment(value="Settings for MariaDB")
    private MysqlDataSourceConfiguration mariadb = new MysqlDataSourceConfiguration();
    @Comment(value="Settings for MySQL")
    private MysqlDataSourceConfiguration mysql = new MysqlDataSourceConfiguration();
    @Comment(value="Settings for Postgres")
    private PostgresDataSourceConfiguration postgres = new PostgresDataSourceConfiguration();
    @Comment(value="Settings for sqlite file-based databases. File-based databases aren't generally\nrecommended but the pros/cons depend entirely on your usage and needs.")
    private SqliteDataSourceConfiguration sqlite = new SqliteDataSourceConfiguration();

    public DataSourceConfiguration primaryDataSource() {
        return switch (this.primaryStorageType) {
            default -> throw new MatchException(null, null);
            case StorageType.H2 -> this.h2;
            case StorageType.MARIADB -> this.mariadb;
            case StorageType.MYSQL -> this.mysql;
            case StorageType.POSTGRES -> this.postgres;
            case StorageType.SQLITE -> this.sqlite;
        };
    }

    @Generated
    public boolean spy() {
        return this.spy;
    }

    @Generated
    public StorageType primaryStorageType() {
        return this.primaryStorageType;
    }

    @Generated
    public FileDataSourceConfiguration h2() {
        return this.h2;
    }

    @Generated
    public MysqlDataSourceConfiguration mariadb() {
        return this.mariadb;
    }

    @Generated
    public MysqlDataSourceConfiguration mysql() {
        return this.mysql;
    }

    @Generated
    public PostgresDataSourceConfiguration postgres() {
        return this.postgres;
    }

    @Generated
    public SqliteDataSourceConfiguration sqlite() {
        return this.sqlite;
    }
}

