/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.dependencies;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.prism_mc.prism.loader.services.dependencies.Dependency;
import org.prism_mc.prism.loader.services.dependencies.relocation.Relocation;
import org.prism_mc.prism.loader.storage.StorageType;

public class DependencyRegistry {
    private static final ListMultimap<StorageType, Dependency> STORAGE_DEPENDENCIES = ImmutableListMultimap.builder().putAll((Object)StorageType.H2, (Object[])new Dependency[]{Dependency.HIKARI, Dependency.JOOQ, Dependency.R2DBC, Dependency.REACTIVE_STREAMS, Dependency.H2_DRIVER}).putAll((Object)StorageType.MARIADB, (Object[])new Dependency[]{Dependency.HIKARI, Dependency.JOOQ, Dependency.R2DBC, Dependency.REACTIVE_STREAMS, Dependency.MARIADB_DRIVER}).putAll((Object)StorageType.MYSQL, (Object[])new Dependency[]{Dependency.HIKARI, Dependency.JOOQ, Dependency.R2DBC, Dependency.REACTIVE_STREAMS, Dependency.MYSQL_DRIVER}).putAll((Object)StorageType.POSTGRES, (Object[])new Dependency[]{Dependency.HIKARI, Dependency.JOOQ, Dependency.R2DBC, Dependency.REACTIVE_STREAMS, Dependency.POSTGRES_DRIVER}).putAll((Object)StorageType.SQLITE, (Object[])new Dependency[]{Dependency.HIKARI, Dependency.JOOQ, Dependency.R2DBC, Dependency.REACTIVE_STREAMS, Dependency.SQLITE_DRIVER}).build();

    public Set<Dependency> globalDependencies() {
        return EnumSet.of(Dependency.AOPALLIANCE, new Dependency[]{Dependency.CAFFEINE, Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_HOCON, Dependency.CRON_UTILS, Dependency.GEANTYREF, Dependency.GUICE, Dependency.GUICE_ASSISTED, Dependency.HOCON_CONFIG, Dependency.JACKSON_ANNOTATIONS, Dependency.JACKSON_CORE, Dependency.JACKSON_DATABIND, Dependency.JAKARTA_INJECT, Dependency.MOONSHINE_CORE, Dependency.MOONSHINE_INTERNAL, Dependency.MOONSHINE_STANDARD, Dependency.P6SPY, Dependency.QUARTZ});
    }

    public Set<Dependency> storageDependencies(StorageType storageType) {
        return new LinkedHashSet<Dependency>(STORAGE_DEPENDENCIES.get((Object)storageType));
    }

    public void applyRelocationSettings(Dependency dependency, List<Relocation> relocations) {
    }

    public boolean shouldAutoLoad(Dependency dependency) {
        return switch (dependency) {
            case Dependency.ASM, Dependency.ASM_COMMONS, Dependency.JAR_RELOCATOR -> false;
            default -> true;
        };
    }
}

