/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.dependencies;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import org.prism_mc.prism.loader.services.dependencies.Dependency;
import org.prism_mc.prism.loader.services.dependencies.DependencyDownloadException;

public enum DependencyRepository {
    PRISM_MIRROR("https://nexus.prism-mc.org/repository/maven-central/"){

        @Override
        protected URLConnection openConnection(Dependency dependency) throws IOException, URISyntaxException {
            URLConnection connection = super.openConnection(dependency);
            connection.setRequestProperty("User-Agent", "prism");
            connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(5L));
            connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(10L));
            return connection;
        }
    }
    ,
    LUCK_MIRROR("https://nexus.lucko.me/repository/maven-central/"){

        @Override
        protected URLConnection openConnection(Dependency dependency) throws IOException, URISyntaxException {
            URLConnection connection = super.openConnection(dependency);
            connection.setRequestProperty("User-Agent", "prism");
            connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(5L));
            connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(10L));
            return connection;
        }
    }
    ,
    MAVEN_CENTRAL("https://repo1.maven.org/maven2/"),
    AIKAR("https://repo.aikar.co/content/groups/aikar/"),
    CODEMC("https://repo.codemc.io/repository/maven-public/");

    private final String url;

    private DependencyRepository(String url) {
        this.url = url;
    }

    protected URLConnection openConnection(Dependency dependency) throws IOException, URISyntaxException {
        URL dependencyUrl = new URI(this.url + dependency.mavenRepoPath()).toURL();
        return dependencyUrl.openConnection();
    }

    public byte[] downloadRaw(Dependency dependency) throws DependencyDownloadException {
        byte[] byArray;
        block9: {
            URLConnection connection = this.openConnection(dependency);
            InputStream in = connection.getInputStream();
            try {
                byte[] bytes = ByteStreams.toByteArray((InputStream)in);
                if (bytes.length == 0) {
                    throw new DependencyDownloadException("Empty stream");
                }
                byArray = bytes;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DependencyDownloadException(e);
                }
            }
            in.close();
        }
        return byArray;
    }

    public byte[] download(Dependency dependency) throws DependencyDownloadException {
        byte[] bytes = this.downloadRaw(dependency);
        byte[] hash = Dependency.createDigest().digest(bytes);
        if (!dependency.checksumMatches(hash)) {
            throw new DependencyDownloadException("Downloaded file had an invalid hash. Expected: " + Base64.getEncoder().encodeToString(dependency.checksum()) + " Actual: " + Base64.getEncoder().encodeToString(hash));
        }
        return bytes;
    }

    public void download(Dependency dependency, Path file) throws DependencyDownloadException {
        try {
            Files.write(file, this.download(dependency), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new DependencyDownloadException(e);
        }
    }
}

