/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.dependencies;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.prism_mc.prism.loader.services.configuration.ConfigurationService;
import org.prism_mc.prism.loader.services.dependencies.Dependency;
import org.prism_mc.prism.loader.services.dependencies.DependencyDownloadException;
import org.prism_mc.prism.loader.services.dependencies.DependencyRegistry;
import org.prism_mc.prism.loader.services.dependencies.DependencyRepository;
import org.prism_mc.prism.loader.services.dependencies.classpath.ClassPathAppender;
import org.prism_mc.prism.loader.services.dependencies.loader.IsolatedClassLoader;
import org.prism_mc.prism.loader.services.dependencies.relocation.Relocation;
import org.prism_mc.prism.loader.services.dependencies.relocation.RelocationHandler;
import org.prism_mc.prism.loader.services.logging.LoggingService;
import org.prism_mc.prism.loader.services.scheduler.ThreadPoolScheduler;

public class DependencyService {
    private final LoggingService loggingService;
    private final ConfigurationService configurationService;
    private final DependencyRegistry registry;
    private final ClassPathAppender classPathAppender;
    private final Path cacheDirectory;
    private final RelocationHandler relocationHandler;
    private final ThreadPoolScheduler threadPoolScheduler;
    private final EnumMap<Dependency, Path> loaded = new EnumMap(Dependency.class);
    private final Map<ImmutableSet<Dependency>, IsolatedClassLoader> loaders = new HashMap<ImmutableSet<Dependency>, IsolatedClassLoader>();

    public DependencyService(LoggingService loggingService, ConfigurationService configurationService, Path dataPath, ClassPathAppender classPathAppender, ThreadPoolScheduler threadPoolScheduler) {
        this.loggingService = loggingService;
        this.configurationService = configurationService;
        this.classPathAppender = classPathAppender;
        this.threadPoolScheduler = threadPoolScheduler;
        this.registry = new DependencyRegistry();
        this.cacheDirectory = this.createDependenciesDirectory(dataPath);
        this.relocationHandler = new RelocationHandler(this);
    }

    private Path createDependenciesDirectory(Path dataPath) {
        Path cacheDirectory = dataPath.resolve("libs");
        try {
            Files.createDirectories(cacheDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create libs directory", e);
        }
        return cacheDirectory;
    }

    private Path downloadDependency(Dependency dependency) throws DependencyDownloadException {
        Path file = this.cacheDirectory.resolve(dependency.fileName(null));
        Path remappedFile = this.cacheDirectory.resolve(dependency.fileName("remapped"));
        if (Files.exists(file, new LinkOption[0]) || Files.exists(remappedFile, new LinkOption[0])) {
            return file;
        }
        this.loggingService.info("Downloading dependency {0}...", dependency.name().toLowerCase(Locale.ENGLISH));
        DependencyDownloadException lastError = null;
        for (DependencyRepository repo : dependency.repositories()) {
            try {
                repo.download(dependency, file);
                return file;
            }
            catch (DependencyDownloadException e) {
                lastError = e;
            }
        }
        throw (DependencyDownloadException)Objects.requireNonNull(lastError);
    }

    public void loadAllDependencies(Set<Dependency> platformDependencies) {
        Set<Dependency> global = this.registry.globalDependencies();
        EnumSet<Dependency> all = EnumSet.copyOf(global);
        all.addAll(this.registry.storageDependencies(this.configurationService.storageConfig().primaryStorageType()));
        all.addAll(platformDependencies);
        this.loadDependencies(all);
    }

    public void loadDependencies(Set<Dependency> dependencies) {
        CountDownLatch latch = new CountDownLatch(dependencies.size());
        for (Dependency dependency : dependencies) {
            this.threadPoolScheduler.async().execute(() -> {
                try {
                    this.loadDependency(dependency);
                }
                catch (Exception e) {
                    this.loggingService.warn("Unable to load dependency: {0}", dependency.name().toLowerCase(Locale.ENGLISH));
                    this.loggingService.handleException(e);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void loadDependency(Dependency dependency) throws Exception {
        if (this.loaded.containsKey((Object)dependency)) {
            return;
        }
        Path downloadFile = this.downloadDependency(dependency);
        if (!downloadFile.toString().contains("remapped")) {
            Path file = this.remapDependency(dependency, downloadFile);
            this.loaded.put(dependency, file);
            if (this.registry.shouldAutoLoad(dependency)) {
                this.classPathAppender.addJarToClasspath(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IsolatedClassLoader obtainClassLoaderWith(Set<Dependency> dependencies) {
        ImmutableSet set = ImmutableSet.copyOf(dependencies);
        for (Dependency dependency : dependencies) {
            if (this.loaded.containsKey((Object)dependency)) continue;
            throw new IllegalStateException("Dependency " + String.valueOf((Object)dependency) + " is not loaded.");
        }
        Map<ImmutableSet<Dependency>, IsolatedClassLoader> map = this.loaders;
        synchronized (map) {
            IsolatedClassLoader classLoader = this.loaders.get(set);
            if (classLoader != null) {
                return classLoader;
            }
            URL[] urls = (URL[])set.stream().map(this.loaded::get).map(file -> {
                try {
                    return file.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new);
            classLoader = new IsolatedClassLoader(urls);
            this.loaders.put((ImmutableSet<Dependency>)set, classLoader);
            return classLoader;
        }
    }

    private Path remapDependency(Dependency dependency, Path originalFile) throws Exception {
        ArrayList<Relocation> rules = new ArrayList<Relocation>(dependency.relocations());
        this.registry.applyRelocationSettings(dependency, rules);
        if (rules.isEmpty()) {
            return originalFile;
        }
        Path remappedFile = this.cacheDirectory.resolve(dependency.fileName("remapped"));
        if (Files.exists(remappedFile, new LinkOption[0])) {
            return remappedFile;
        }
        this.relocationHandler.remap(originalFile, remappedFile, rules);
        Path downloadedFile = this.cacheDirectory.resolve(dependency.fileName(null));
        Files.deleteIfExists(downloadedFile);
        return remappedFile;
    }
}

