/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.dependencies.loader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.prism_mc.prism.loader.services.dependencies.loader.LoadingException;
import org.prism_mc.prism.loader.services.dependencies.loader.PrismBootstrap;

public class JarInJarClassLoader
extends URLClassLoader {
    public JarInJarClassLoader(ClassLoader loaderClassLoader, String jarResourcePath) throws LoadingException {
        super(new URL[]{JarInJarClassLoader.extractJar(loaderClassLoader, jarResourcePath)}, loaderClassLoader);
    }

    public void addJarToClasspath(URL url) {
        this.addURL(url);
    }

    public void deleteJarResource() {
        URL[] urls = this.getURLs();
        if (urls.length == 0) {
            return;
        }
        try {
            Path path = Paths.get(urls[0].toURI());
            Files.deleteIfExists(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> PrismBootstrap instantiatePlugin(String bootstrapClass, Class<T> loaderPluginType, T loaderPlugin) throws LoadingException {
        Constructor<PrismBootstrap> constructor;
        Class<PrismBootstrap> plugin;
        try {
            plugin = this.loadClass(bootstrapClass).asSubclass(PrismBootstrap.class);
        }
        catch (ReflectiveOperationException e) {
            throw new LoadingException("Unable to load bootstrap class", e);
        }
        try {
            constructor = plugin.getConstructor(loaderPluginType);
        }
        catch (ReflectiveOperationException e) {
            throw new LoadingException("Unable to get bootstrap constructor", e);
        }
        try {
            return constructor.newInstance(loaderPlugin);
        }
        catch (ReflectiveOperationException e) {
            throw new LoadingException("Unable to create bootstrap plugin instance", e);
        }
    }

    private static URL extractJar(ClassLoader loaderClassLoader, String jarResourcePath) throws LoadingException {
        Path path;
        URL jarInJar = loaderClassLoader.getResource(jarResourcePath);
        if (jarInJar == null) {
            throw new LoadingException("Could not locate jar-in-jar");
        }
        try {
            path = Files.createTempFile("prism-jarinjar", ".jar.tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LoadingException("Unable to create a temporary file", e);
        }
        path.toFile().deleteOnExit();
        try (InputStream in = jarInJar.openStream();){
            Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new LoadingException("Unable to copy jar-in-jar to temporary path", e);
        }
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new LoadingException("Unable to get URL from path", e);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

