/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.dependencies.relocation;

import java.util.Objects;

public final class Relocation {
    private static final String RELOCATION_PREFIX = "org.prism_mc.prism.libs.";
    private final String pattern;
    private final String relocatedPattern;

    public static Relocation of(String id, String pattern) {
        return new Relocation(pattern.replace("{}", "."), RELOCATION_PREFIX + id);
    }

    private Relocation(String pattern, String relocatedPattern) {
        this.pattern = pattern;
        this.relocatedPattern = relocatedPattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getRelocatedPattern() {
        return this.relocatedPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relocation that = (Relocation)o;
        return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.relocatedPattern, that.relocatedPattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.relocatedPattern);
    }
}

