/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.prism_mc.prism.loader.services.configuration.ConfigurationService;

public class LoggingService {
    private final ConfigurationService configurationService;
    private final Logger logger;

    public LoggingService(ConfigurationService configurationService, Logger logger) {
        this.configurationService = configurationService;
        this.logger = logger;
    }

    public void debug(String message) {
        if (this.configurationService.prismConfig().debug()) {
            this.logger.info(message);
        }
    }

    public void debug(String message, Object ... args) {
        if (this.configurationService.prismConfig().debug()) {
            this.logger.log(Level.INFO, message, args);
        }
    }

    public void error(String message) {
        this.logger.log(Level.SEVERE, message);
    }

    public void error(String message, Object ... args) {
        this.logger.log(Level.SEVERE, message, args);
    }

    public void handleThrowable(String message, Throwable throwable) {
        this.logger.log(Level.SEVERE, message, throwable);
    }

    public void handleException(Exception exception) {
        this.logger.log(Level.SEVERE, "An exception occurred", exception);
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void info(String message, Object ... args) {
        this.logger.log(Level.INFO, message, args);
    }

    public void warn(String message) {
        this.logger.log(Level.WARNING, message);
    }

    public void warn(String message, Object ... args) {
        this.logger.log(Level.WARNING, message, args);
    }
}

