/*
 * Decompiled with CFR 0.152.
 */
package org.prism_mc.prism.loader.services.scheduler;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.prism_mc.prism.loader.services.dependencies.loader.PluginLoader;

public class ThreadPoolScheduler {
    private static final int PARALLELISM = 16;
    private final PluginLoader loader;
    private final ScheduledThreadPoolExecutor scheduler;
    private final ForkJoinPool worker;

    public ThreadPoolScheduler(PluginLoader loader) {
        this.loader = loader;
        this.scheduler = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("prism-scheduler");
            return thread;
        });
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.worker = new ForkJoinPool(16, new WorkerThreadFactory(), new ExceptionHandler(), false);
    }

    public Executor async() {
        return this.worker;
    }

    public void shutdownScheduler() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.loader.loggingService().warn("Timed out waiting for the Prism scheduler to terminate");
                this.reportRunningTasks(thread -> thread.getName().equals("prism-scheduler"));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void shutdownExecutor() {
        this.worker.shutdown();
        try {
            if (!this.worker.awaitTermination(1L, TimeUnit.MINUTES)) {
                this.loader.loggingService().warn("Timed out waiting for the Prism worker thread pool to terminate");
                this.reportRunningTasks(thread -> thread.getName().startsWith("prism-worker-"));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void reportRunningTasks(Predicate<Thread> predicate) {
        Thread.getAllStackTraces().forEach((thread, stack) -> {
            if (predicate.test((Thread)thread)) {
                this.loader.loggingService().warn("Thread " + thread.getName() + " is blocked, and may be the reason for the slow shutdown!\n" + Arrays.stream(stack).map(el -> "  " + String.valueOf(el)).collect(Collectors.joining("\n")));
            }
        });
    }

    private static final class WorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private static final AtomicInteger COUNT = new AtomicInteger(0);

        private WorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            thread.setDaemon(true);
            thread.setName("prism-worker-" + COUNT.getAndIncrement());
            return thread;
        }
    }

    private final class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ThreadPoolScheduler.this.loader.loggingService().error("Thread {0} threw an uncaught exception", t.getName());
            ThreadPoolScheduler.this.loader.loggingService().error(e.getMessage());
        }
    }
}

