#version 330

bool CompareVec3(vec3 val1,vec3 val2,vec3 maxdiff) {

    return all(lessThan(abs(val1 - val2), maxdiff));
}

bool IsMinecart() {

    vec2 corner0 = vec2(1 / 64.0,1 / 32.0);
    vec2 corner1 = vec2(18 / 64.0,1 / 32.0);
    vec2 corner2 = vec2(36 / 64.0,9 / 32.0);
    vec2 corner3 = vec2(44 / 64.0,28 / 32.0);

    bvec4 check = bvec4(
        texture(Sampler0, corner0).a == 0,
        texture(Sampler0, corner1).a == 0,
        texture(Sampler0, corner2).a == 0,
        texture(Sampler0, corner3).a == 0
        );

    return all(check);
}

bool IsValid() {

    return (
        IsMinecart() &&
        (
            CompareVec3(normalize(abs(Normal)),normalize(vec3(1.025,0.5,0.45)),vec3(0.01)) ||
            CompareVec3(normalize(abs(Normal)),normalize(vec3(0.3,0.75,0.135)),vec3(0.01)) ||
            CompareVec3(normalize(abs(Normal)),normalize(vec3(0.435,0,0.985)),vec3(0.01))
        )
    );
}
