/*
 * Decompiled with CFR 0.152.
 */
package me.manolopro3333.owleafutils;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.manolopro3333.owleafutils.commands.UtilCommand;
import me.manolopro3333.owleafutils.network.BlockF1Packet;
import me.manolopro3333.owleafutils.network.BlockF3Packet;
import me.manolopro3333.owleafutils.network.BypassPacket;
import me.manolopro3333.owleafutils.network.GlobalShiftPacket;
import me.manolopro3333.owleafutils.network.ShiftPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

@Mod(value="owleafutils")
public class Owleafutils {
    public static final String MODID = "owleafutils";
    private static final String PROTOCOL_VERSION = "1";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean globalF1Blocked = false;
    private static boolean globalF3Blocked = false;
    private static boolean globalShiftBlocked = false;
    private static final Set<String> f1BypassPlayers = new HashSet<String>();
    private static final Set<String> f3BypassPlayers = new HashSet<String>();
    private static final Set<String> shiftBypassPlayers = new HashSet<String>();
    private static boolean clientF1Blocked = false;
    private static boolean clientF3Blocked = false;
    private static final Map<String, Boolean> clientIndividualShiftBlocked = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> playerShiftStatus = new ConcurrentHashMap<String, Boolean>();
    public static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("owleafutils", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public Owleafutils() {
        Owleafutils.registerPackets();
        LOGGER.info("[OwleafUtils] cargado exitosamente.");
    }

    public static void setClientF1Blocked(boolean blocked) {
        clientF1Blocked = blocked;
    }

    public static void setClientF3Blocked(boolean blocked) {
        clientF3Blocked = blocked;
    }

    public static void setClientIndividualShiftBlocked(String player, boolean blocked) {
        clientIndividualShiftBlocked.put(player, blocked);
    }

    public static boolean isClientF1Blocked() {
        return clientF1Blocked;
    }

    public static boolean isClientF3Blocked() {
        return clientF3Blocked;
    }

    public static boolean isClientIndividualShiftBlocked(String player) {
        return clientIndividualShiftBlocked.getOrDefault(player, false);
    }

    public static boolean getPlayerShiftStatus(String player) {
        return playerShiftStatus.getOrDefault(player, false);
    }

    public static void registerPackets() {
        NETWORK.registerMessage(packetId++, BlockF1Packet.class, BlockF1Packet::encode, BlockF1Packet::decode, BlockF1Packet::handle);
        NETWORK.registerMessage(packetId++, BlockF3Packet.class, BlockF3Packet::encode, BlockF3Packet::decode, BlockF3Packet::handle);
        NETWORK.registerMessage(packetId++, ShiftPacket.class, ShiftPacket::encode, ShiftPacket::decode, ShiftPacket::handle);
        NETWORK.registerMessage(packetId++, GlobalShiftPacket.class, GlobalShiftPacket::encode, GlobalShiftPacket::decode, GlobalShiftPacket::handle);
        NETWORK.registerMessage(packetId++, BypassPacket.class, BypassPacket::encode, BypassPacket::decode, BypassPacket::handle);
    }

    public static void sendGlobalShiftPacket(boolean blocked) {
        NETWORK.send(PacketDistributor.ALL.noArg(), (Object)new GlobalShiftPacket(blocked));
    }

    public static void sendBlockF1Packet(boolean blocked) {
        NETWORK.send(PacketDistributor.ALL.noArg(), (Object)new BlockF1Packet(blocked));
    }

    public static void sendBlockF3Packet(boolean blocked) {
        NETWORK.send(PacketDistributor.ALL.noArg(), (Object)new BlockF3Packet(blocked));
    }

    public static void sendShiftPacket(String playerName, boolean individualBlocked) {
        NETWORK.send(PacketDistributor.ALL.noArg(), (Object)new ShiftPacket(playerName, individualBlocked));
    }

    public static boolean isF1Blocked() {
        return globalF1Blocked;
    }

    public static void setF1Blocked(boolean b) {
        globalF1Blocked = b;
    }

    public static boolean hasF1Bypass(String p) {
        return f1BypassPlayers.contains(p);
    }

    public static Set<String> getF1BypassPlayers() {
        return f1BypassPlayers;
    }

    public static boolean isF3Blocked() {
        return globalF3Blocked;
    }

    public static void setF3Blocked(boolean b) {
        globalF3Blocked = b;
    }

    public static boolean hasF3Bypass(String p) {
        return f3BypassPlayers.contains(p);
    }

    public static Set<String> getF3BypassPlayers() {
        return f3BypassPlayers;
    }

    public static boolean isShiftBlocked() {
        return globalShiftBlocked;
    }

    public static void setShiftBlocked(boolean b) {
        globalShiftBlocked = b;
    }

    public static boolean hasShiftBypass(String p) {
        return shiftBypassPlayers.contains(p);
    }

    public static Set<String> getShiftBypassPlayers() {
        return shiftBypassPlayers;
    }

    public static void toggleShiftStatus(String playerName) {
        playerShiftStatus.put(playerName, !Owleafutils.getPlayerShiftStatus(playerName));
    }

    @Mod.EventBusSubscriber(modid="owleafutils", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return;
            }
            String name = mc.f_91074_.m_7755_().getString();
            if (Owleafutils.isClientF1Blocked() && !Owleafutils.hasF1Bypass(name)) {
                mc.f_91066_.f_92062_ = false;
            }
            if (Owleafutils.isClientF3Blocked() && !Owleafutils.hasF3Bypass(name)) {
                mc.f_91066_.f_92063_ = false;
            }
        }

        @SubscribeEvent
        public static void onInputUpdate(MovementInputUpdateEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof LocalPlayer)) {
                return;
            }
            LocalPlayer player2 = (LocalPlayer)player;
            String name = player2.m_7755_().getString();
            if (Owleafutils.isShiftBlocked() && !Owleafutils.hasShiftBypass(name)) {
                event.getInput().f_108573_ = false;
            }
            if (Owleafutils.isClientIndividualShiftBlocked(name)) {
                event.getInput().f_108573_ = false;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="owleafutils", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerEvents {
        @SubscribeEvent
        public static void onCommandRegister(RegisterCommandsEvent event) {
            UtilCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            String name = player.m_7755_().getString();
            Owleafutils.sendBlockF1Packet(Owleafutils.isF1Blocked());
            Owleafutils.sendBlockF3Packet(Owleafutils.isF3Blocked());
            Owleafutils.sendGlobalShiftPacket(Owleafutils.isShiftBlocked());
            playerShiftStatus.put(name, false);
            Owleafutils.sendShiftPacket(name, false);
        }
    }
}

