/*
 * Decompiled with CFR 0.152.
 */
package me.manolopro3333.owleafutils.network;

import java.util.function.Supplier;
import me.manolopro3333.owleafutils.Owleafutils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class BlockF1Packet {
    private final boolean blocked;

    public BlockF1Packet(boolean blocked) {
        this.blocked = blocked;
    }

    public static void encode(BlockF1Packet packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.blocked);
    }

    public static BlockF1Packet decode(FriendlyByteBuf buf) {
        return new BlockF1Packet(buf.readBoolean());
    }

    public static void handle(BlockF1Packet packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Owleafutils.setClientF1Blocked(packet.blocked)));
        contextSupplier.get().setPacketHandled(true);
    }
}

