/*
 * Decompiled with CFR 0.152.
 */
package me.manolopro3333.owleafutils.network;

import java.util.function.Supplier;
import me.manolopro3333.owleafutils.Owleafutils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class BlockF3Packet {
    private final boolean blocked;

    public BlockF3Packet(boolean blocked) {
        this.blocked = blocked;
    }

    public static void encode(BlockF3Packet packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.blocked);
    }

    public static BlockF3Packet decode(FriendlyByteBuf buf) {
        return new BlockF3Packet(buf.readBoolean());
    }

    public static void handle(BlockF3Packet packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Owleafutils.setClientF3Blocked(packet.blocked)));
        contextSupplier.get().setPacketHandled(true);
    }
}

