/*
 * Decompiled with CFR 0.152.
 */
package me.manolopro3333.owleafutils.network;

import java.util.function.Supplier;
import me.manolopro3333.owleafutils.Owleafutils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class GlobalShiftPacket {
    private final boolean blocked;

    public GlobalShiftPacket(boolean blocked) {
        this.blocked = blocked;
    }

    public static void encode(GlobalShiftPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.blocked);
    }

    public static GlobalShiftPacket decode(FriendlyByteBuf buf) {
        return new GlobalShiftPacket(buf.readBoolean());
    }

    public static void handle(GlobalShiftPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Owleafutils.setShiftBlocked(msg.blocked)));
        ctx.get().setPacketHandled(true);
    }
}

