/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders;

import com.platypushasnohat.tome_of_wonders.TomeOfWondersConfig;
import com.platypushasnohat.tome_of_wonders.TomeOfWondersTab;
import com.platypushasnohat.tome_of_wonders.data.TOWBiomeTagProvider;
import com.platypushasnohat.tome_of_wonders.data.TOWBlockTagProvider;
import com.platypushasnohat.tome_of_wonders.data.TOWDamageTypeTagProvider;
import com.platypushasnohat.tome_of_wonders.data.TOWDatapackProvider;
import com.platypushasnohat.tome_of_wonders.data.TOWEntityTagProvider;
import com.platypushasnohat.tome_of_wonders.data.TOWItemModelProvider;
import com.platypushasnohat.tome_of_wonders.data.TOWLanguageProvider;
import com.platypushasnohat.tome_of_wonders.data.TOWLootProvider;
import com.platypushasnohat.tome_of_wonders.data.TOWPaintingTagProvider;
import com.platypushasnohat.tome_of_wonders.data.TOWRecipeProvider;
import com.platypushasnohat.tome_of_wonders.data.TOWSoundDefinitionProvider;
import com.platypushasnohat.tome_of_wonders.events.ForgeEvents;
import com.platypushasnohat.tome_of_wonders.registry.TOWBlockEntities;
import com.platypushasnohat.tome_of_wonders.registry.TOWBlocks;
import com.platypushasnohat.tome_of_wonders.registry.TOWBrewingRecipes;
import com.platypushasnohat.tome_of_wonders.registry.TOWEntities;
import com.platypushasnohat.tome_of_wonders.registry.TOWItems;
import com.platypushasnohat.tome_of_wonders.registry.TOWPaintings;
import com.platypushasnohat.tome_of_wonders.registry.TOWParticles;
import com.platypushasnohat.tome_of_wonders.registry.TOWPotions;
import com.platypushasnohat.tome_of_wonders.registry.TOWSoundEvents;
import com.platypushasnohat.tome_of_wonders.utils.ClientProxy;
import com.platypushasnohat.tome_of_wonders.utils.CommonProxy;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="tome_of_wonders")
public class TomeOfWonders {
    public static final String MOD_ID = "tome_of_wonders";
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);

    public TomeOfWonders() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::dataSetup);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TomeOfWondersConfig.COMMON_CONFIG, "tome-of-wonders-general.toml");
        TOWItems.ITEMS.register(modEventBus);
        TOWBlocks.BLOCKS.register(modEventBus);
        TOWBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        TOWEntities.ENTITY_TYPES.register(modEventBus);
        TOWPotions.POTIONS.register(modEventBus);
        TOWSoundEvents.SOUND_EVENTS.register(modEventBus);
        TOWParticles.PARTICLE_TYPES.register(modEventBus);
        TOWPaintings.PAINTING_VARIANTS.register(modEventBus);
        TomeOfWondersTab.CREATIVE_TAB.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEvents());
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(TOWBrewingRecipes::registerPotionRecipes);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(PROXY::clientInit);
    }

    private void dataSetup(GatherDataEvent data) {
        DataGenerator generator = data.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = data.getLookupProvider();
        ExistingFileHelper helper = data.getExistingFileHelper();
        boolean server = data.includeServer();
        TOWDatapackProvider datapackEntries = new TOWDatapackProvider(output, provider);
        generator.addProvider(server, (DataProvider)datapackEntries);
        provider = datapackEntries.getRegistryProvider();
        TOWBlockTagProvider blockTags = new TOWBlockTagProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new TOWEntityTagProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new TOWBiomeTagProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new TOWDamageTypeTagProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new TOWRecipeProvider(output));
        generator.addProvider(server, (DataProvider)new TOWPaintingTagProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)TOWLootProvider.register(output));
        boolean client = data.includeClient();
        generator.addProvider(client, (DataProvider)new TOWItemModelProvider(data));
        generator.addProvider(client, (DataProvider)new TOWSoundDefinitionProvider(output, helper));
        generator.addProvider(client, (DataProvider)new TOWLanguageProvider(data));
    }

    public static ResourceLocation modPrefix(String name) {
        return new ResourceLocation(MOD_ID, name.toLowerCase(Locale.ROOT));
    }
}

