/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.blocks.blockentity;

import com.platypushasnohat.tome_of_wonders.blocks.WhirliboxBlock;
import com.platypushasnohat.tome_of_wonders.registry.TOWBlockEntities;
import com.platypushasnohat.tome_of_wonders.registry.TOWParticles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WhirliboxBlockEntity
extends BlockEntity {
    public WhirliboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TOWBlockEntities.WHIRLIBOX_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WhirliboxBlockEntity whirlibox) {
        if (((Boolean)state.m_61143_((Property)WhirliboxBlock.POWERED)).booleanValue()) {
            whirlibox.push(state, (Direction)state.m_61143_((Property)WhirliboxBlock.FACING), (Direction)state.m_61143_((Property)WhirliboxBlock.FACING), level.m_277086_(pos));
        }
    }

    private void push(BlockState state, Direction direction, Direction moveDirection, int power) {
        BlockPos targetPos;
        BlockState targetState;
        int blockDist;
        if (this.f_58857_ == null) {
            return;
        }
        for (blockDist = 1; blockDist <= power && ((targetState = this.f_58857_.m_8055_(targetPos = this.f_58858_.m_5484_(direction, blockDist))).m_60795_() || targetState.m_60812_((BlockGetter)this.f_58857_, targetPos).m_83281_()); ++blockDist) {
        }
        if (blockDist > 1) {
            List entities = this.f_58857_.m_45933_(null, new AABB(this.f_58858_).m_82369_(new Vec3(direction.m_253071_().mul((float)blockDist))));
            for (Entity entity : entities) {
                Vec3 vec3 = new Vec3(direction.m_253071_()).m_82541_().m_82490_(0.09);
                Vec3 vec31 = new Vec3(direction.m_253071_()).m_82541_().m_82490_(0.055);
                if (entity.m_6047_()) {
                    entity.m_20256_(entity.m_20184_().m_82549_(vec31));
                } else {
                    entity.m_20256_(entity.m_20184_().m_82549_(vec3));
                }
                if (entity instanceof FallingBlockEntity) {
                    FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
                    --fallingBlock.f_31942_;
                }
                entity.m_183634_();
            }
        }
        if (this.f_58857_.m_5776_()) {
            double xOff = (float)direction.m_122429_() * 0.15f;
            double yOff = (float)direction.m_122430_() * 0.15f;
            double zOff = (float)direction.m_122431_() * 0.15f;
            double particleOffset = moveDirection.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 : -1.0;
            for (int j = 1; j < blockDist; ++j) {
                if (!(this.f_58857_.f_46441_.m_188501_() <= 0.15f)) continue;
                BlockPos targetPos2 = this.f_58858_.m_5484_(direction, j);
                double x = (double)targetPos2.m_123341_() + this.getParticlePos(xOff, this.f_58857_.f_46441_, particleOffset);
                double y = (double)targetPos2.m_123342_() + this.getParticlePos(yOff, this.f_58857_.f_46441_, particleOffset);
                double z = (double)targetPos2.m_123343_() + this.getParticlePos(zOff, this.f_58857_.f_46441_, particleOffset);
                if (this.f_58857_.m_8055_(targetPos2).m_60713_(Blocks.f_49990_)) {
                    this.f_58857_.m_7106_((ParticleOptions)TOWParticles.WHIRLIBUBBLE.get(), x, y, z, xOff, yOff, zOff);
                    continue;
                }
                this.f_58857_.m_7106_((ParticleOptions)TOWParticles.WHIRLIWIND.get(), x, y, z, xOff, yOff, zOff);
            }
        }
    }

    private double getParticlePos(double offset, RandomSource random, double offset1) {
        return offset == 0.0 ? (double)(0.5f + (random.m_188501_() + random.m_188501_() - 1.0f) / 2.0f) : 0.5 + offset1 * (double)(random.m_188501_() - 1.25f);
    }
}

