/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.platypushasnohat.tome_of_wonders.client.animations.BaitfishAnimations;
import com.platypushasnohat.tome_of_wonders.entities.Baitfish;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BaitfishModel
extends HierarchicalModel<Baitfish> {
    private final ModelPart root;
    private final ModelPart bottomfin;
    private final ModelPart topfin;
    private final ModelPart tailfin;

    public BaitfishModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.bottomfin = this.root.m_171324_("bottomfin");
        this.topfin = this.root.m_171324_("topfin");
        this.tailfin = this.root.m_171324_("tailfin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -1.0f, -5.0f, 1.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)-1.0f));
        PartDefinition bottomfin = root.m_171599_("bottomfin", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition topfin = root.m_171599_("topfin", CubeListBuilder.m_171558_().m_171514_(14, 12).m_171488_(0.0f, -1.0f, -1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition tailfin = root.m_171599_("tailfin", CubeListBuilder.m_171558_().m_171514_(8, 12).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(Baitfish entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.flopAnimationState, BaitfishAnimations.FLOP, ageInTicks);
        this.m_233381_(entity.swimmingAnimationState, BaitfishAnimations.SWIM, ageInTicks);
        float prevOnLandProgress = entity.prevOnLandProgress;
        float onLandProgress = entity.onLandProgress;
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float landProgress = prevOnLandProgress + (onLandProgress - prevOnLandProgress) * partialTicks;
        this.root.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.root.f_104205_ += landProgress * ((float)Math.toRadians(-90.0) / 5.0f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

