/*
 * Decompiled with CFR 0.152.
 */
package com.platypushasnohat.tome_of_wonders.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.platypushasnohat.tome_of_wonders.client.animations.FlyingFishAnimations;
import com.platypushasnohat.tome_of_wonders.entities.FlyingFish;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlyingFishModel
extends HierarchicalModel<FlyingFish> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart dorsalfin;
    private final ModelPart leftpelvicfin;
    private final ModelPart rightpelvicfin;
    private final ModelPart tailfin;
    private final ModelPart backwingright;
    private final ModelPart backwingleft;
    private final ModelPart leftwing;
    private final ModelPart rightwing;

    public FlyingFishModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.tail = this.body.m_171324_("tail");
        this.dorsalfin = this.tail.m_171324_("dorsalfin");
        this.leftpelvicfin = this.tail.m_171324_("leftpelvicfin");
        this.rightpelvicfin = this.tail.m_171324_("rightpelvicfin");
        this.tailfin = this.tail.m_171324_("tailfin");
        this.backwingright = this.tail.m_171324_("backwingright");
        this.backwingleft = this.tail.m_171324_("backwingleft");
        this.leftwing = this.body.m_171324_("leftwing");
        this.rightwing = this.body.m_171324_("rightwing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition dorsalfin = tail.m_171599_("dorsalfin", CubeListBuilder.m_171558_().m_171514_(12, 18).m_171488_(0.0f, -1.0f, -1.5f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.005f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)2.5f));
        PartDefinition leftpelvicfin = tail.m_171599_("leftpelvicfin", CubeListBuilder.m_171558_().m_171514_(18, 12).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.005f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)4.0f));
        PartDefinition rightpelvicfin = tail.m_171599_("rightpelvicfin", CubeListBuilder.m_171558_().m_171514_(18, 12).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)4.0f));
        PartDefinition tailfin = tail.m_171599_("tailfin", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171488_(0.0f, -2.0f, -1.0f, 0.0f, 7.0f, 5.0f, new CubeDeformation(0.005f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.0f));
        PartDefinition backwingright = tail.m_171599_("backwingright", CubeListBuilder.m_171558_().m_171514_(8, 18).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.005f)), PartPose.m_171419_((float)-1.0f, (float)1.0f, (float)2.0f));
        PartDefinition backwingleft = tail.m_171599_("backwingleft", CubeListBuilder.m_171558_().m_171514_(8, 18).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.005f)), PartPose.m_171419_((float)1.0f, (float)1.0f, (float)2.0f));
        PartDefinition leftwing = body.m_171599_("leftwing", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.005f)), PartPose.m_171419_((float)1.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition rightwing = body.m_171599_("rightwing", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, -10.0f, 0.0f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.005f)), PartPose.m_171419_((float)-1.0f, (float)-1.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(FlyingFish entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.flopAnimationState, FlyingFishAnimations.FLOP, ageInTicks);
        this.m_233381_(entity.glidingAnimationState, FlyingFishAnimations.SKIM, ageInTicks);
        this.m_233385_(entity.swimmingAnimationState, FlyingFishAnimations.SWIM, ageInTicks, 0.5f + limbSwingAmount * 1.5f);
        float prevOnLandProgress = entity.prevOnLandProgress;
        float onLandProgress = entity.onLandProgress;
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float landProgress = prevOnLandProgress + (onLandProgress - prevOnLandProgress) * partialTicks;
        if (!entity.isGliding()) {
            this.root.f_104203_ = headPitch * ((float)Math.PI / 180);
        }
        this.root.f_104205_ += landProgress * ((float)Math.toRadians(-90.0) / 5.0f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

